package net.wicp.tams.common.binlog.alone;

import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.parser.BaseLogFetcher;
import net.wicp.tams.common.binlog.alone.parser.ParseLogOnline;

public abstract class BinlogStart {

// 通过配置去监听任务
	public static void listening(ConnConf.Builder connConfBuilder) {
		BaseLogFetcher logFetcher = new ParseLogOnline(connConfBuilder);
		logFetcher.read();
	}

	public static void listeningNonBlocking(final ConnConf.Builder connConfBuilder) {
		Thread listenThread = new Thread(new Runnable() {
			@Override
			public void run() {
				listening(connConfBuilder);
			}
		});
		listenThread.setDaemon(true);
		listenThread.start();
	}

}
