/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.filter.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.binlog.alone.Config;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEventItem;
import net.wicp.tams.common.binlog.alone.ListenerConf.OptType;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.filter.IFilter;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

@Slf4j
public class FilterForSql implements IFilter {

	private DataSource dataSource;

	@SuppressWarnings("resource")
	@Override
	public void doFilter(DuckulaEvent.Builder data, Rule rule, RuleFilter filterRulePo) {
		Connection connection = null;
		PreparedStatement prst = null;
		try {
			String[] colNameFormSql = getColNameFormSql(filterRulePo.getRuleValue());
			String sql = filterRulePo.getRuleValue();
			for (String tempCol : colNameFormSql) {
				sql = sql.replace(String.format("@{%s}", tempCol), "?");
			}

			for (int i = data.getItemsCount() - 1; i >= 0; i--) {
				DuckulaEventItem itemBuild = data.getItems(i);
				Map<String, String> datamap;
				if (data.getOptType() != OptType.delete) {
					datamap = itemBuild.getAfterMap();
				} else {
					datamap = itemBuild.getBeforeMap();
				}
				Object[] queryParams = new String[colNameFormSql.length];
				boolean isDel = false;
				for (int j = 0; j < colNameFormSql.length; j++) {
					String value = datamap.get(colNameFormSql[j]);
					if (StringUtil.isNull(value)) {// 20190813 如果有值为空就直接过滤
						data.removeItems(i);
						isDel = true;
						break;
					} else {
						queryParams[j] = value;
					}
				}
				if (isDel) {
					continue;
				}
				if (connection == null || connection.isClosed()) {
					// connection =
					// DruidAssit.getConnection(MDC.get(Config.CurThreadDatasourceName));
					if (this.dataSource == null) {
						this.dataSource = PerthreadManager.getInstance()
								.createValue(Config.CurThreadDatasourceName, DataSource.class).get(null);
					}
					connection = this.dataSource.getConnection();
					prst = connection.prepareStatement(sql);
				}
				JdbcAssit.setPreParam(prst, true, queryParams);
				ResultSet rs = prst.executeQuery();
				if (!rs.next()) {
					data.removeItems(i);
					continue;
				} else {
					// log.info("need send no:{},remove:{}", rowIndex, remove.size());
				}
				rs.close();
			}
		} catch (Exception e) {
			log.error("过滤失败", e);
		} finally {
			try {
				if (connection != null) {
					connection.close();
				}
				if (prst != null) {
					prst.close();
				}
			} catch (SQLException e) {
			}
		}
	}

	private String[] getColNameFormSql(String sql) {
		List<String> retlist = new ArrayList<String>();
		int i = 0;
		while (true) {
			int j = sql.indexOf("@{", i);
			if (j > 0) {
				int k = sql.indexOf("}", j);
				String temp = sql.substring(j + 2, k);
				i = k + 1;
				retlist.add(temp);
			} else {
				break;
			}
		}
		return retlist.toArray(new String[retlist.size()]);
	}

	@Override
	public void doFilter(DumpEvent data, Rule rule, RuleFilter filterRulePo) {
		// TODO Auto-generated method stub
	}
}
