/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.filter.impl;

import java.util.Map;

import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEventItem;
import net.wicp.tams.common.binlog.alone.ListenerConf.OptType;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.filter.IFilter;
import net.wicp.tams.common.constant.StrPattern;

public class FilterForRegular implements IFilter {
	@Override
	public void doFilter(DuckulaEvent.Builder data, Rule rule, RuleFilter filterRulePo) {
		for (int i = data.getItemsCount() - 1; i >= 0; i--) {
			DuckulaEventItem itemBuild = (DuckulaEventItem) data.getItems(i);
			String value;
			if (data.getOptType() != OptType.delete) {
				value = itemBuild.getAfterMap().get(filterRulePo.getField());
			} else {
				value = itemBuild.getBeforeMap().get(filterRulePo.getField());
			}
			boolean checkResult = StrPattern.checkStrFormat(filterRulePo.getRuleValue(), value);
			if (!checkResult) {
				data.removeItems(i);
			}
		}
	}

	@Override
	public void doFilter(DumpEvent data, Rule rule, RuleFilter filterRulePo) {
		for (int i = data.getDatas().size() - 1; i >= 0; i--) {
			Map<String, String> datamap = data.getDatas().get(i);
			String value = datamap.get(filterRulePo.getField());
			boolean checkResult = StrPattern.checkStrFormat(filterRulePo.getRuleValue(), value);
			if (!checkResult) {
				data.getDatas().remove(i);
			}
		}
	}

}
