/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.dump.listener;

import java.io.Serializable;
import java.util.Map;

import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.constant.ods.AddColName;

public interface IBusiSender<DumpEvent> {
	/****
	 * 传入dump，用于区分dump
	 * 
	 * @param dump
	 */
	public void init(Dump dump);

	/***
	 * 附加字段，不需要处理“逻辑删除”
	 * 
	 * @param dumpEvent
	 * @param addValues
	 * @param newDb
	 * @param newTb
	 * @param isSplit   是否分隔成单条发送，默认为否，意味着一批批发送
	 */
	public void doSend(DumpEvent dumpEvent, Map<AddColName, Serializable> addValues, String newDb, String newTb,
			boolean isSplit);
}
