/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.dump.bean;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiFilter;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.dbType.BinlogType;

/**
 * dump配置
 * 
 * @author 偏锋书生
 *
 */
@Data
@Builder
public class Dump {
	private String id;// 页面配置的任务id
	private String jdbcSourceName;//支持多数据库实例时，记录连接池的名称
	// private String dbPattern;
	// private String tbPattern;
	// private String dbDemo;
	// private String tbDemo;
	private String[] primarysLogic;// 逻辑主键，某些情况下会用它来做为es的docId,如果它定义了就不会使用primarys，如：从表的外键并不是主表的主键的情况
	private String[] primarys;
	private String[] needCols;// 需要导出的列
	private BinlogType[] needColTypes;// 需要导出列的类型
	private int numDuan;
	private String wheresql;// where语句
	private String[] startId;// 从哪个ID开始导入,多主键
	private Long numDump;// 导多少记录数
	// private String esSetting;//是否需要nojoin模式
	private IBusiFilter<DumpEvent> busiFilter;
	private IBusiSender<DumpEvent> busiSender;
	private Rule rule;
	private List<Pair<String, String>> dbtbs;
	private final DbType dbType;//mysql或doris。暂时支持

	// private DumpGroup metric;

	private volatile String lastId[];

	// private String dbOri;// 去掉模式后的db值
	// private String tbOri;// 去掉模式后的tb值

	//private JSONObject busiPluginConfig;// 可能会是插件用的扩展属性 由于采用了Conf和rule管理，废弃

//	public String getDbOri() {
//		if (StringUtil.isNull(dbOri)) {
//			this.dbOri = dbDemo;
//		}
//		return this.dbOri;
//	}

//	public String getTbOri() {
//		if (StringUtil.isNull(tbOri)) {
//			this.tbOri = tbDemo;
//		}
//		return this.tbOri;
//	}

	public Pair<String, String> getRootDbTb() {
		return Pair.of(this.rule.getDrds().getRootDb(this.dbtbs.get(0).getLeft()),
				this.rule.getDrds().getRootDb(this.dbtbs.get(0).getRight()));
	}

	/**
	 * 得到from sql
	 * 
	 * @param dbtb 原表的库名、表名
	 * @return
	 */
	public String packFromstr(Pair<String, String> dbtb) {
		if (StringUtil.isNotNull(this.wheresql)) {
			this.wheresql = StringUtil.trimSpace(this.wheresql);
			if (!this.getWheresql().substring(0, 5).equalsIgnoreCase("where")) {
				this.wheresql = "where " + this.wheresql;
			}
		}
		String fromstr = String.format("from %s %s", String.format("`%s`.`%s`", dbtb.getLeft(), dbtb.getRight()),
				StringUtil.isNull(this.getWheresql()) ? "where 1=1 " : this.getWheresql());
		return fromstr;
	}

	

	/*
	 * @SuppressWarnings("unchecked") public IBusiSender<DumpEvent> getSender() { if
	 * (this.sender == null) { try { IBusiSender<DumpEvent> newInstance =
	 * (IBusiSender<DumpEvent>)
	 * busiSendClass.getConstructor(Dump.class).newInstance(this); this.sender =
	 * newInstance;
	 * 
	 * } catch (Exception e) { throw new RuntimeException("没有实例", e); } } return
	 * this.sender; }
	 */

}
