/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.constant;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * cosumer用到的解析器
 * 
 * @author andy.zhou
 * 
 */
public enum Formarter implements IEnumCombobox {
	duckula("duckula数据", "net.wicp.tams.duckula.consumer.impl.KafkaConsumer"),

	sensorsdata("神策数据", "net.wicp.tams.duckula.consumer.impl.SensorsdataConsumer");

	private final String desc;

	private final String formaterClass;// 实现类IConsumer<T>

	public String getFormaterClass() {
		return formaterClass;
	}

	private Formarter(String desc, String formaterClass) {
		this.desc = desc;
		this.formaterClass = formaterClass;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static Formarter find(String name) {
		if (StringUtils.isEmpty(name)) {
			return duckula;
		}
		for (Formarter ele : Formarter.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return duckula;
	}

}
