/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.constant;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.filter.IFilter;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForColname;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForFunction;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForOpttype;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForRegular;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForSql;

@Slf4j
public enum FilterPattern {
	opttype("操作类型过滤", false, "other", 0, new FilterForOpttype()), // 只能有insert/update/delete

	regular("正则表达式", true, "row", 1, new FilterForRegular()),

	sql("带参数SQL", false, "row", 2, new FilterForSql()),

	function("自定义函数，考虑使用脚本语言", false, "row", 3, new FilterForFunction()),

	colname("列名过滤", false, "col", 999, new FilterForColname())

	;

//	public static final String db_tb_formart = "%s|%s|%s";

	private final String desc;
	private final boolean hasColName;// 需要设置列名
	private final String group;// row:行过滤,col:列过滤
	private final int index;
	private final IFilter filter;

	// key:db_tb_formart value:{} key:field,value:Set<String> 规则值,容许多条
	/*
	 * private final Map<String, Map<String, Set<String>>> filterRules = new
	 * HashMap<String, Map<String, Set<String>>>();
	 * 
	 * public Map<String, Map<String, Set<String>>> getFilterRules() { return
	 * this.filterRules; }
	 */

	public IFilter getFilter() {
		return filter;
	}

	public int getIndex() {
		return index;
	}

	public String getDesc() {
		return desc;
	}

	private FilterPattern(String desc, boolean hasColName, String group, int index, IFilter filter) {
		this.desc = desc;
		this.hasColName = hasColName;
		this.group = group;
		this.index = index;
		this.filter = filter;
	}

	public String getGroup() {
		return group;
	}

	public boolean isHasColName() {
		return hasColName;
	}

	public static JSONArray getJson(Map<FilterPattern, Map<String, Map<String, Set<String>>>> inputmap) {
		JSONArray retall = new JSONArray();
		if (MapUtils.isEmpty(inputmap)) {
			return retall;
		}
		for (FilterPattern filterPattern : inputmap.keySet()) {
			JSONArray ret = new JSONArray();
			Map<String, Map<String, Set<String>>> filterRules = inputmap.get(filterPattern);
			for (String db_tb : filterRules.keySet()) {
				String[] db_tb_ary = db_tb.split("\\|");
				Map<String, Set<String>> map = filterRules.get(db_tb);
				for (String field : map.keySet()) {
					Set<String> ruleSet = map.get(field);
					if (CollectionUtils.isNotEmpty(ruleSet)) {
						String[] ruleAry = ruleSet.toArray(new String[ruleSet.size()]);
						for (int i = 0; i < ruleAry.length; i++) {
							JSONObject tempjson = new JSONObject();
							tempjson.put("db", db_tb_ary[0]);
							tempjson.put("tb", db_tb_ary[1]);
							tempjson.put("drds", db_tb_ary[2]);
							tempjson.put("field", field);
							tempjson.put("index", i);
							tempjson.put("rule", filterPattern.name());
							tempjson.put("ruleValue", ruleAry[i]);
							ret.add(tempjson);
						}
					}
				}
			}
			retall.addAll(ret);
		}
		return retall;
	}

	// 把grid数据转为string放入输入框
	public static String toString(JSONArray ruleJsonAry) {
		TreeSet<RuleFilter> tempset = new TreeSet<RuleFilter>();
		for (int i = 0; i < ruleJsonAry.size(); i++) {
			JSONObject jsonObject = ruleJsonAry.getJSONObject(i);
			RuleFilter temppo = new RuleFilter();
			FilterPattern filterPattern = FilterPattern.valueOf(jsonObject.getString("rule"));
			temppo.setFilterPattern(filterPattern);
			if (!filterPattern.isHasColName()) {
				temppo.setField("_");
			} else {
				temppo.setField(jsonObject.getString("field"));
			}
			temppo.setIndex(jsonObject.getIntValue("index"));
			temppo.setRuleValue(jsonObject.getString("ruleValue"));
			tempset.add(temppo);
		}
		// 暂时
		return ruleJsonAry.toJSONString();
	}

}
