/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.binlog.bean;

import org.apache.commons.lang3.Validate;

import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

public enum RuleItem {
	parent("父规则"),//如：test:user_addr
	
	topic("消息主题"),
	
	colNameTime("时间区间时应用的字段"),//全量时使用
	
	dateFormatCase("时间格式，与时间区间配合使用"),//与colNameTime配对使用。

	key("es需要主键的colName"), //
	
	keyformart("redis的主键formart"),//redis的主键formart
	
	routeColName("路由字段名"),//redis的tenantid等。暂只支持一个路由字段

	relakey("es中关联表的key"), // "table1:key|table2:key",如果只有一张表直接输入key名就OK  //kafka级联逻辑，多主键逗号隔开，
	
	updateColName("CDC中的全增量分隔字段"),//在CDC中，每套rule都必须要指定updateCol,时间轴的分隔字段名，一般是updatetime，由于不同的表会有不同的字段名。

	//cachecloud不支持
	@Deprecated
	appid("cachecloud的使用类型和appid，中间用|分隔，默认为standalone"), // 格式“standalone|10000”或 “sentinel|10000”

	//不支持连接多个redis,只连一个rddis，在中间件配置里决定
	//redisurl("redis的url"), // ,格式“standalone|127.0.0.1:6279”或
							// “sentinel|mastername|127.0.0.1:6279,127.0.0.1:6278,127.0.0.1:6277”
							// “null”或者不配置就使用middleware的配置结果

	splitkey("分库分表键"), 

	index("es的index"),

	type("es的type"),
	
	join("es的索引类型"),//yes:是join，no：不是join

	many("es的配置"), //最新设计：user_id:true 表示关联关系字段是user_id，true：一对多的关系 // 配置es是主表还是从表，如： test:user_info:main|test:user_addr:user_id:true
						// 表示user_info是主表，而user_addr是从表，且user_id是关联字段
	

	primarysLogic("逻辑外键"), // 20200610 一般es的从表的外键是主表的主键，特殊情况下，外键是其中一个非主键，在此配置，如
							// tax_code与tax_goods,那么tax_good的docId要用它定义的字段不能用主键
	//// 逻辑主键，某些情况下会用它来做为es的docId,如果它定义了就不会使用primarys，如：从表的外键并不是主表的主键的情况

	copynum("复制份数"), // es自动创建index用

	partitions("分区数"), // es自动创建index用

	middleware("存储中间件配置"), // es消费时需要指定中间件的配置

	dbinstanceid("consumer的jdbc发送者需要"),

	tb("目标表"),
	
	db("目标库"), //用于sink到相应的库，用于ods全量导
	
	redisDb("默认数据库"), //redis的默认数据库
	
	tbConver("dbtb转换器"), //导出用的db

	ks("cassandra用的名称空间"), // 20200122 cassandra等使用的名称空间

	table("consumer的jdbc发送者需要，中间用.分隔"), // 20200122 cassandra等数据库使用的表名

	colName("附加的列名"), // 在冪等模式下有用

	addProp("附加的属性"), // 附加的固定属性

	httpRela("httpUrl相对地址"), // http插件

	// dump专用
	wheresql("查询的语句"),

	startId("开始同步的id"),

	numDump("要导出的记录数"),

	needCols("插件需要的配置"),

	other("未知参数");

	private final String desc;

	private RuleItem(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public static String[] splitAppId(String appidValue) {
		Validate.notEmpty(appidValue, "appid不能为空值");
		String[] splitary = appidValue.split("\\|");
		if (splitary.length == 1) {
			return new String[] { "standalone", splitary[0] };
		} else {
			return splitary;
		}
	}

	public static String[] splitRedisurl(String redisurlValue) {
		Validate.notEmpty(redisurlValue, "redisurl不能为空值");
		String[] splitary = redisurlValue.split("\\|");
		Validate.isTrue(splitary.length > 1, "redisurl格式不对");
		if ("standalone".equals(splitary[0])) {
			return splitary;
		} else if ("sentinel".equals(splitary[0])) {
			String[] hostandports = splitary[2].split(",");
			String[] retary = new String[hostandports.length + 2];
			retary[0] = splitary[0];
			retary[1] = splitary[1];
			System.arraycopy(hostandports, 0, retary, 2, hostandports.length);
			return retary;
		} // 集群未支持
		throw new ProjectExceptionRuntime(ExceptAll.project_nosupport);
	}

	public static RuleItem get(String name) {
		for (RuleItem ruleItem : RuleItem.values()) {
			if (ruleItem.name().equalsIgnoreCase(name)) {
				return ruleItem;
			}
		}
		return null;
	}

}
