/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.binlog.bean;

import com.alibaba.fastjson.JSONObject;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.constant.FilterPattern;

@Getter
@Setter
@EqualsAndHashCode(of = { "field", "index" })
public class RuleFilter implements Comparable<RuleFilter> {
	private String field;
	private int index;
	private FilterPattern filterPattern;
	private String ruleValue;
	
	
	public JSONObject toJson() {
		JSONObject retobj=new JSONObject();
		if(StringUtil.isNotNull(field)) {
			retobj.put("field", field);
		}
		retobj.put("index",index);
		retobj.put("rule",filterPattern.name());
		retobj.put("ruleValue", ruleValue);
		return retobj;
	}

	@Override
	public int compareTo(RuleFilter o) {
		int ruleDef = this.filterPattern.getIndex() - o.filterPattern.getIndex();
		if (ruleDef != 0) {
			return ruleDef;
		}
		int deff = this.index - o.getIndex();
		if (deff != 0) {
			return deff;
		}
		int fieldDif = this.field.compareToIgnoreCase(o.getField());
		return fieldDif;
	}
}
