/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.constant.ods.AddColNameType;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DuckulaAssit {
    public static SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static ListenerConf.DuckulaEvent parse(byte[] data) throws InvalidProtocolBufferException {
        ListenerConf.DuckulaEvent retobj = ListenerConf.DuckulaEvent.parseFrom(data);
        return retobj;
    }

    public static Pair<JSONObject, ListenerConf.DuckulaEvent> parseHedge(byte[] data, String changeColName, boolean isLogic) throws InvalidProtocolBufferException {
        if (data == null || StringUtil.isNull((Object)changeColName)) {
            return null;
        }
        ListenerConf.DuckulaEvent oriData = ListenerConf.DuckulaEvent.parseFrom(data);
        if (oriData.getOptType() == ListenerConf.OptType.delete) {
            return null;
        }
        String valueAfter = (String)DuckulaAssit.getValueAfter(oriData, 0, changeColName);
        if (StringUtil.isNull((Object)valueAfter)) {
            return null;
        }
        ListenerConf.DuckulaEvent.Builder oriDataBuilder = oriData.toBuilder();
        JSONObject before = JSONObject.parseObject((String)String.valueOf(valueAfter));
        if (before == null || before.isEmpty()) {
            return null;
        }
        JSONObject keyUpdateJson = new JSONObject();
        JSONObject keyTarget = DuckulaAssit.getKeyJson(oriDataBuilder, 0);
        for (String key : before.keySet()) {
            int keyIndex = oriDataBuilder.getColsList().indexOf((Object)key);
            if (oriDataBuilder.getKeyindexsList().contains(keyIndex)) {
                Serializable keyValue = DuckulaAssit.getValue(oriDataBuilder.getColsType(keyIndex), before.getString(key));
                keyUpdateJson.put(key, (Object)keyValue);
                keyTarget.put(key, (Object)keyValue);
            }
            oriDataBuilder.getItemsBuilder(0).putAfter(key, before.getString(key));
        }
        if (keyUpdateJson.isEmpty()) {
            return null;
        }
        int optIndex = oriData.getColsList().indexOf((Object)AddColName.lastOpttype.getColNameTrue());
        int isdeleteIndex = oriData.getColsList().indexOf((Object)AddColName.isDelete.getColNameTrue());
        if (isdeleteIndex >= 0) {
            oriDataBuilder.getItemsBuilder(0).putAfter(AddColName.isDelete.getColNameTrue(), "1");
        }
        if (isLogic) {
            oriDataBuilder.setOptType(ListenerConf.OptType.update);
            if (optIndex >= 0) {
                oriDataBuilder.getItemsBuilder(0).putAfter(AddColName.lastOpttype.getColNameTrue(), ListenerConf.OptType.update.name());
            }
        } else {
            oriDataBuilder.setOptType(ListenerConf.OptType.delete);
            if (optIndex >= 0) {
                oriDataBuilder.getItemsBuilder(0).putAfter(AddColName.lastOpttype.getColNameTrue(), ListenerConf.OptType.delete.name());
            }
        }
        return Pair.of((Object)keyTarget, (Object)oriDataBuilder.build());
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static Map<String, String> getColNamesMap(ListenerConf.DuckulaEvent duckulaEvent, FieldFormart fieldFormart) {
        HashMap<String, String> retmap = new HashMap<String, String>();
        for (int i = 0; i < duckulaEvent.getColsCount(); ++i) {
            retmap.put(duckulaEvent.getCols(i), fieldFormart.getColName(duckulaEvent.getCols(i)));
        }
        return retmap;
    }

    public static ListenerConf.DuckulaEvent convertEvent(ListenerConf.DuckulaEvent oriEvent, FieldFormart fieldFormart) {
        if (fieldFormart == FieldFormart.ori) {
            return oriEvent;
        }
        ListenerConf.DuckulaEvent.Builder returBuilder = oriEvent.toBuilder();
        if (fieldFormart != FieldFormart.ori) {
            int i;
            for (i = 0; i < returBuilder.getColsCount(); ++i) {
                returBuilder.setCols(i, fieldFormart.getColName(returBuilder.getCols(i)));
            }
            for (i = 0; i < returBuilder.getItemsCount(); ++i) {
                Map<String, String> beforeMap;
                ListenerConf.DuckulaEventItem.Builder newBuilder = ListenerConf.DuckulaEventItem.newBuilder();
                ListenerConf.DuckulaEventItem.Builder oldBuilder = returBuilder.getItemsBuilder(i);
                newBuilder.setVersion(oldBuilder.getVersion());
                Map<String, String> afterMap = oldBuilder.getAfterMap();
                if (MapUtils.isNotEmpty(afterMap)) {
                    for (String key : afterMap.keySet()) {
                        newBuilder.putAfter(fieldFormart.getColName(key), afterMap.get(key));
                    }
                }
                if (MapUtils.isNotEmpty(beforeMap = oldBuilder.getBeforeMap())) {
                    for (String key : beforeMap.keySet()) {
                        newBuilder.putBefore(fieldFormart.getColName(key), beforeMap.get(key));
                    }
                }
                returBuilder.setItems(i, newBuilder);
            }
        }
        return returBuilder.build();
    }

    public static <T extends Serializable> List<Pair<String, T>> getKey(ListenerConf.DuckulaEvent.Builder duckulaEventBuilder, int index) {
        Integer[] integerArray;
        Map<String, String> datamap;
        Map<String, String> map = datamap = !DuckulaAssit.isAfter(duckulaEventBuilder.getOptType()) ? duckulaEventBuilder.getItems(index).getBeforeMap() : duckulaEventBuilder.getItems(index).getAfterMap();
        if (duckulaEventBuilder.getKeyindexsCount() == 0) {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = 0;
        } else {
            integerArray = duckulaEventBuilder.getKeyindexsList().toArray(new Integer[duckulaEventBuilder.getKeyindexsCount()]);
        }
        Integer[] keysindex = integerArray;
        ArrayList<Pair<String, T>> retlist = new ArrayList<Pair<String, T>>();
        for (int i = 0; i < keysindex.length; ++i) {
            String keyName = duckulaEventBuilder.getCols(keysindex[i]);
            String value = datamap.get(keyName);
            ListenerConf.ColumnType columnType = duckulaEventBuilder.getColsType(keysindex[i]);
            Object retobj = value;
            switch (columnType) {
                case LONGLONG: {
                    retobj = Long.valueOf(value);
                    break;
                }
                case BIT: 
                case TINY: 
                case SHORT: 
                case INT24: 
                case LONG: 
                case ENUM: 
                case SET: {
                    retobj = Integer.valueOf(value);
                    break;
                }
            }
            retlist.add(Pair.of((Object)keyName, (Object)retobj));
        }
        return retlist;
    }

    public static String[] getKeyColname(ListenerConf.DuckulaEvent duckulaEvent) {
        Integer[] integerArray;
        if (duckulaEvent.getKeyindexsCount() == 0) {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = 0;
        } else {
            integerArray = duckulaEvent.getKeyindexsList().toArray(new Integer[duckulaEvent.getKeyindexsCount()]);
        }
        Integer[] keysindex = integerArray;
        String[] retAry = new String[keysindex.length];
        for (int i = 0; i < retAry.length; ++i) {
            retAry[i] = duckulaEvent.getCols(i);
        }
        return retAry;
    }

    public static String getKeyJoin(ListenerConf.DuckulaEvent.Builder duckulaEventBuilder, int index, String splitChat) {
        List keyValues = DuckulaAssit.getKey(duckulaEventBuilder, index);
        String splitChatStr = StringUtils.isEmpty((CharSequence)splitChat) ? "," : splitChat;
        StringBuffer buf = new StringBuffer();
        for (Pair keyValue : keyValues) {
            buf.append(splitChatStr);
            buf.append(keyValue.getRight());
        }
        return buf.substring(1);
    }

    public static JSONObject getKeyJson(ListenerConf.DuckulaEvent.Builder duckulaEventBuilder, int index) {
        List<Pair<String, Serializable>> keyValues = DuckulaAssit.getKey(duckulaEventBuilder, index);
        return PluginAssit.getKeySplit(keyValues);
    }

    public static ListenerConf.DuckulaEvent.Builder buildSinglItemDuckulaEvent(ListenerConf.DuckulaEvent.Builder duckulaEventBuilder, int index) {
        ListenerConf.DuckulaEvent.Builder duckulaEventbuilder = null;
        while (true) {
            try {
                duckulaEventbuilder = duckulaEventBuilder.clone();
            }
            catch (Throwable e) {
                System.out.println("\u6709\u65f6\u53d1\u751fclone\u5f02\u5e38?\u4e0d\u660e\u4ec0\u4e48\u539f\u56e0!\u5df2\u505a\u5904\u7406\uff0c\u4e0d\u4f1a\u5bfc\u81f4\u6570\u636e\u4e22\u5931\u3002" + e.getMessage());
                continue;
            }
            break;
        }
        ListenerConf.DuckulaEventItem curItems = duckulaEventbuilder.getItems(index);
        duckulaEventbuilder.clearItems();
        duckulaEventbuilder.addItems(curItems);
        return duckulaEventbuilder;
    }

    public static <T extends Serializable> T getValueAfter(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName) {
        return DuckulaAssit.getValue(duckulaEvent, index, colName, true);
    }

    public static <T extends Serializable> T getValueBefore(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName) {
        return DuckulaAssit.getValue(duckulaEvent, index, colName, false);
    }

    public static <T extends Serializable> T getValue(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName) {
        return DuckulaAssit.getValue(duckulaEvent, index, colName, DuckulaAssit.isAfter(duckulaEvent.getOptType()));
    }

    public static <T extends Serializable> T getValue(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName, boolean isAfter) {
        if (duckulaEvent.getColsCount() != duckulaEvent.getColsList().size()) {
            throw new RuntimeException("\u5217\u540d\u4e0e\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u3002");
        }
        String value = DuckulaAssit.getValueStr(duckulaEvent, index, colName, isAfter);
        if (DuckulaAssit.isEmpty(value)) {
            return null;
        }
        int colindex = duckulaEvent.getColsList().indexOf((Object)colName);
        Serializable retobj = DuckulaAssit.getValue(duckulaEvent.getColsType(colindex), value);
        return (T)retobj;
    }

    public static Serializable getValue(ListenerConf.ColumnType columnType, String value) {
        Object retobj = null;
        switch (columnType) {
            case LONGLONG: {
                retobj = Long.valueOf(value);
                break;
            }
            case BIT: 
            case TINY: 
            case SHORT: 
            case INT24: 
            case LONG: 
            case ENUM: 
            case SET: {
                retobj = Integer.valueOf(value);
                break;
            }
            case FLOAT: {
                retobj = Float.valueOf(value);
                break;
            }
            case DOUBLE: {
                retobj = Double.valueOf(value);
                break;
            }
            case DECIMAL: 
            case NEWDECIMAL: {
                retobj = new BigDecimal(value);
                break;
            }
            case GEOMETRY: {
                try {
                    retobj = Base64.decodeBase64((String)value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case YEAR: {
                try {
                    retobj = Integer.valueOf(value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case TIMESTAMP2: 
            case DATETIME2: {
                try {
                    retobj = formater.parse(value);
                }
                catch (ParseException e) {
                    retobj = value;
                }
                break;
            }
            default: {
                retobj = value;
            }
        }
        return retobj;
    }

    public static String getValueStr(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName) {
        return DuckulaAssit.getValueStr(duckulaEvent, index, colName, DuckulaAssit.isAfter(duckulaEvent.getOptType()));
    }

    public static String getValueStr(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName, boolean isAfter) {
        ListenerConf.DuckulaEventItem item = duckulaEvent.getItems(index);
        String value = isAfter ? item.getAfterMap().get(colName) : item.getBeforeMap().get(colName);
        return value;
    }

    public static boolean isAfter(ListenerConf.OptType optType) {
        return optType != ListenerConf.OptType.delete && optType != ListenerConf.OptType.updateBefore;
    }

    public static Map<String, String> getValueMap(ListenerConf.DuckulaEvent duckulaEvent, int index) {
        ListenerConf.DuckulaEventItem item = duckulaEvent.getItems(index);
        Map<String, String> retMap = DuckulaAssit.isAfter(duckulaEvent.getOptType()) ? item.getAfterMap() : item.getBeforeMap();
        return retMap;
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static JSONObject convertJson(ListenerConf.DuckulaEvent duckulaEvent) {
        JSONObject retobj = new JSONObject();
        retobj.put("optType", (Object)duckulaEvent.getOptType());
        JSONArray items = new JSONArray();
        for (ListenerConf.DuckulaEventItem duckulaEventItem : duckulaEvent.getItemsList()) {
            JSONObject itemobj = new JSONObject();
            switch (duckulaEvent.getOptType()) {
                case update: {
                    itemobj.put("after", duckulaEventItem.getAfterMap());
                    itemobj.put("before", duckulaEventItem.getBeforeMap());
                    break;
                }
                case insert: {
                    itemobj.put("after", duckulaEventItem.getAfterMap());
                    break;
                }
                case delete: {
                    itemobj.put("before", duckulaEventItem.getBeforeMap());
                    break;
                }
            }
            items.add((Object)itemobj);
        }
        retobj.put("items", (Object)items);
        return retobj;
    }

    public static Map<AddColName, Serializable> getAddColValues(ListenerConf.DuckulaEvent duckulaEvent, AddColNameType addColNameType) {
        HashMap<AddColName, String> addValues = null;
        if (addColNameType != AddColNameType.no) {
            addValues = new HashMap<AddColName, String>();
            for (AddColName addColName : AddColName.values()) {
                boolean logicDel;
                if ((addColNameType == AddColNameType.selective || addColNameType == AddColNameType.selective_ori) && !addColName.isSetValue() && (!(logicDel = Conf.getBoolean((String)"common.binlog.alone.binlog.global.logicDel").booleanValue()) || addColName != AddColName.lastOpttype && addColName != AddColName.commitTime && addColName != AddColName.isDelete)) continue;
                addValues.put(addColName, DuckulaAssit.getAddColValue(duckulaEvent, addColName));
            }
        }
        return addValues;
    }

    public static String getAddColValue(ListenerConf.DuckulaEvent duckulaEvent, AddColName addColName) {
        String retvalue = "";
        switch (addColName) {
            case commitTime: {
                String tempValue;
                if (duckulaEvent.getCommitTime() <= 0L) break;
                retvalue = tempValue = DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(new Date(duckulaEvent.getCommitTime()));
                break;
            }
            case dumpTime: {
                String tempValue;
                if (duckulaEvent.getDumpTime() <= 0L) break;
                retvalue = tempValue = DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(new Date(duckulaEvent.getDumpTime()));
                break;
            }
            case isDelete: {
                retvalue = !DuckulaAssit.isAfter(duckulaEvent.getOptType()) ? "1" : "0";
                break;
            }
            case lastOpttype: {
                retvalue = duckulaEvent.getOptType().name();
                break;
            }
            case oriDb: {
                retvalue = duckulaEvent.getDb();
                break;
            }
            case oriTb: {
                retvalue = duckulaEvent.getTb();
                break;
            }
            case oriInstid: {
                retvalue = String.valueOf(duckulaEvent.getDbInstanceId());
                break;
            }
        }
        return retvalue;
    }

    public static JSONObject getChangedUpdateBefore(ListenerConf.DuckulaEvent duckulaEvent, int index) {
        if (duckulaEvent.getOptType() == ListenerConf.OptType.update && duckulaEvent.getItemsCount() >= index + 1 && MapUtils.isNotEmpty(duckulaEvent.getItems(index).getBeforeMap())) {
            JSONObject retjson = new JSONObject();
            Map<String, String> beforeMap = duckulaEvent.getItems(index).getBeforeMap();
            Map<String, String> afterMap = duckulaEvent.getItems(index).getAfterMap();
            for (String colName : duckulaEvent.getColsList()) {
                String afterValue;
                if (!beforeMap.containsKey(colName) && !afterMap.containsKey(colName)) continue;
                if (beforeMap.containsKey(colName) && !afterMap.containsKey(colName)) {
                    retjson.put(colName, DuckulaAssit.getValue(duckulaEvent, index, colName));
                    continue;
                }
                if (!beforeMap.containsKey(colName) && afterMap.containsKey(colName)) {
                    retjson.put(colName, null);
                    continue;
                }
                String beforeValue = beforeMap.get(colName);
                if (beforeValue.equals(afterValue = afterMap.get(colName))) continue;
                retjson.put(colName, DuckulaAssit.getValueBefore(duckulaEvent, index, colName));
            }
            return retjson;
        }
        return null;
    }

    public static Map<String, String> getAddColValuesStr(Map<AddColName, Serializable> addValues, FieldFormart fieldFormart) {
        HashMap<String, String> retmap = new HashMap<String, String>();
        for (AddColName addColName : addValues.keySet()) {
            String value = null;
            value = String.valueOf(addValues.get(addColName));
            retmap.put(addColName.getColNameTrue(fieldFormart), value);
        }
        return retmap;
    }

    public static Map<String, String> getAddColValuesStr(ListenerConf.DuckulaEvent duckulaEvent, AddColNameType addColNameType, FieldFormart fieldFormart) {
        return DuckulaAssit.getAddColValuesStr(DuckulaAssit.getAddColValues(duckulaEvent, addColNameType), fieldFormart);
    }

    public static ListenerConf.Position.Builder getMastStatus(Connection conn) {
        ResultSet rs = JdbcAssit.querySql((Connection)conn, (String)"show master status");
        try {
            if (rs.next()) {
                String filename = rs.getString(1);
                long pos = rs.getLong(2);
                ListenerConf.Position.Builder ret = ListenerConf.Position.newBuilder();
                ret.setFileName(filename);
                ret.setPos(pos);
                if (rs.getMetaData().getColumnCount() >= 5) {
                    String gtidStr = rs.getString(5);
                    ret.setGtids(gtidStr.replace("/n", ""));
                }
                if ((rs = JdbcAssit.querySql((Connection)conn, (String)"show variables like 'server_id'")).next()) {
                    long masterServerId = rs.getLong(2);
                    ret.setMasterServerId(masterServerId);
                }
                if ((rs = JdbcAssit.querySql((Connection)conn, (String)"SELECT unix_timestamp(now())")).next()) {
                    long time = rs.getLong(1) * 1000L;
                    ret.setTime(time);
                    ret.setTimeStr(DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(time));
                }
                ListenerConf.Position.Builder builder = ret;
                return builder;
            }
            try {
                throw new RuntimeException("\u6ca1\u6709\u5f97\u5230mastStatus,\u670d\u52a1\u5668\u4e0d\u652f\u6301binlog");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

