package net.wicp.tams.common.binlog.alone.constant;

import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 是与否枚举
 * 
 * @author andy.zhou
 * 
 */
public enum ExportColType implements IEnumCombobox {
	hasKeyAndRoute("导出key和route"),
	
	hasKeyOnly("只导出key"),

	hasRouteOnly("只导出route"),

	no("key和route都不导出");

	private final String desc;

	private ExportColType(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public void filter(Map<String, String> data, String routeCol, String... idCols) {
		if (this == hasKeyAndRoute) {
			return;
		}
		switch (this) {
		case hasKeyOnly:
			if (StringUtil.isNotNull(routeCol)) {
				data.remove(routeCol);
			}
			break;
		case hasRouteOnly:
			if (ArrayUtils.isNotEmpty(idCols)) {
				for (String idCol : idCols) {
					data.remove(idCol);
				}
			}
			break;
		case no:
			if (StringUtil.isNotNull(routeCol)) {
				data.remove(routeCol);
			}
			if (ArrayUtils.isNotEmpty(idCols)) {
				for (String idCol : idCols) {
					data.remove(idCol);
				}
			}
			break;
		default:
			break;
		}
	}
}
