/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.constant;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 发送给插件的模式
 * 
 * @author andy.zhou
 * 
 */
public enum AsyncPattern implements IEnumCombobox {
	no("不启用异步模式"),

	one("数据和时间满足一个就发送"),

	time("只有时间到了才发送"),

	num("只有数量满了才发送"),

	all("数量和时间都达到了才发送");

	private final String desc;

	private AsyncPattern(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static AsyncPattern find(String name) {
		if (StringUtils.isEmpty(name)) {
			return AsyncPattern.no;
		}
		for (AsyncPattern ele : AsyncPattern.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return AsyncPattern.no;
	}

}
