/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone;

import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.callback.IDbTbConvert;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.constant.ods.AddColNameType;

public abstract class Config {
	public static final String globleDatasourceName = "_global";
	public static final String CurThreadDatasourceName = "_curthread";
	public static final String batchRunningConfigKey="batch.running.configKey";

	public static void putColName() {
		AddColName.addColType = Conf.getEnum(AddColNameType.class, "common.binlog.alone.global.addColNameType");
		// 不管什么情况，配置的值还是要设置好的。
		Map<String, String> pre = Conf.getPre("common.binlog.alone.global.addColName.", true);
		for (AddColName addColName : AddColName.values()) {
			if (pre.containsKey(addColName.name()) && StringUtil.isNotNull(pre.get(addColName.name()))) {
				addColName.setColName(pre.get(addColName.name()));
			}
		}

	}
	
	public static Pair<String, String> convertNewDbTb(Rule rule,Pair<String, String> oriDbtb){
		String newDb = rule.getItems().get(RuleItem.db);
		String newTb = rule.getItems().get(RuleItem.tb);
		IDbTbConvert dbTbConvert = rule.getDbTbConvert();
		if (dbTbConvert != null && StringUtil.isNull(newTb)) {
			Pair<String, String> dbAndTb = dbTbConvert.getDbAndTb(rule.getItems().get(RuleItem.db),
					Pair.of(oriDbtb.getLeft(), oriDbtb.getRight()));
			newDb = dbAndTb.getLeft();
			newTb = dbAndTb.getRight();
		}
		if (dbTbConvert == null && StringUtil.isNull(newDb)) {
			newDb = oriDbtb.getLeft();
		}
		if (dbTbConvert == null && StringUtil.isNull(newTb)) {
			newTb = oriDbtb.getRight();
		}
		return Pair.of(newDb, newTb);
	}

}
