/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.binlog.listener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.listener.ICallback;
import net.wicp.tams.common.binlog.alone.binlog.listener.IConsumerListener;
import net.wicp.tams.common.binlog.alone.constant.AsyncPattern;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.constant.ods.AddColNameType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsConsumerListener
implements IConsumerListener {
    private static final Logger log = LoggerFactory.getLogger(AbsConsumerListener.class);
    private final boolean logicDel = Conf.getBoolean((String)"common.binlog.alone.binlog.global.logicDel");
    private final FieldFormart fieldFormart = (FieldFormart)Conf.getEnum(FieldFormart.class, (String)"common.binlog.alone.global.fieldFormart");
    private final AsyncPattern asyncPattern = (AsyncPattern)Conf.getEnum(AsyncPattern.class, (String)"common.binlog.alone.global.async.pattern", (Enum)AsyncPattern.no);
    private boolean isSplit;
    private boolean isMerge = Conf.getEnum(YesOrNo.class, (String)"common.binlog.alone.global.async.merge", (Enum)YesOrNo.yes) == YesOrNo.yes;
    private final long maxTime = Long.parseLong(Conf.get((String)"common.binlog.alone.global.async.time", (String)"0")) * 1000L;
    private final int num = Integer.parseInt(Conf.get((String)"common.binlog.alone.global.async.num", (String)"0"));
    private Map<Rule, List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase = new HashMap<Rule, List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>>>();
    private Pair<CountDownLatch, CountDownLatch> countDownLatch = Pair.of((Object)new CountDownLatch(1), (Object)new CountDownLatch(1));
    private long curTime = System.currentTimeMillis();
    private int itemNum = 0;
    private final ListenerConf.Position.Builder lastGtid = ListenerConf.Position.newBuilder();
    private ListenerConf.Position.Builder lastGtidOver;
    private ICallback overCallBack;

    protected FieldFormart getFieldFormart() {
        return this.fieldFormart;
    }

    public void setOverCallBack(ICallback overCallBack) {
        this.overCallBack = overCallBack;
    }

    public AbsConsumerListener() {
        if (this.maxTime > 0L && (this.asyncPattern == AsyncPattern.time || this.asyncPattern == AsyncPattern.all || this.asyncPattern == AsyncPattern.one)) {
            ScheduledExecutorService timerService = Executors.newSingleThreadScheduledExecutor();
            timerService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            long runTime = System.currentTimeMillis();
                            if (runTime - AbsConsumerListener.this.curTime < AbsConsumerListener.this.maxTime) break;
                            AbsConsumerListener.this.curTime = runTime;
                            boolean isSended = AbsConsumerListener.this.doBusiTrueSync(true);
                            if (!isSended || AbsConsumerListener.this.lastGtidOver == null) break;
                            PluginAssit.setCheckPoint(AbsConsumerListener.this.lastGtidOver.clone());
                        }
                        catch (Throwable e) {
                            boolean reDoWait = TimeAssist.reDoWait((String)"common-binlog-alone_Listener", (int)5);
                            if (reDoWait) {
                                log.error("\u53d1\u9001\u5931\u8d25\uff0c\u5df2\u8fbe5\u6b21\u4e0a\u9650\uff0c\u9000\u51fa\u865a\u62df\u673a", e);
                                LoggerUtil.exit((JvmStatus)JvmStatus.s15);
                                continue;
                            }
                            log.error("\u53d1\u9001\u5931\u8d25\uff0c\u91cd\u8bd5", e);
                            continue;
                        }
                        break;
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public final ListenerConf.Position.Builder doBui(Rule rule, ListenerConf.DuckulaEvent duckulaEvent, boolean isSplit) {
        boolean isSend = false;
        while (true) {
            try {
                this.isSplit = isSplit;
                ListenerConf.DuckulaEvent event = DuckulaAssit.convertEvent(duckulaEvent, this.fieldFormart);
                switch (this.asyncPattern) {
                    case no: {
                        Map<AddColName, Serializable> addValues = DuckulaAssit.getAddColValues(duckulaEvent, AddColName.addColType);
                        this.doBusiTrueOne(rule, event, addValues, isSplit, this.logicDel);
                        break;
                    }
                    case num: 
                    case one: 
                    case all: {
                        this.addData(rule, event);
                        if (this.itemNum < this.num) break;
                        isSend = this.doBusiTrueSync(false);
                        break;
                    }
                    case time: {
                        this.addData(rule, event);
                        if (System.currentTimeMillis() - this.curTime < this.maxTime) break;
                        isSend = this.doBusiTrueSync(true);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                boolean reDoWait = TimeAssist.reDoWait((String)"common-binlog-alone_Listener", (int)5);
                if (reDoWait) {
                    log.error("\u53d1\u9001\u5931\u8d25\uff0c\u5df2\u8fbe5\u6b21\u4e0a\u9650\uff0c\u9000\u51fa\u865a\u62df\u673a", e);
                    LoggerUtil.exit((JvmStatus)JvmStatus.s15);
                    continue;
                }
                log.error("\u53d1\u9001\u5931\u8d25\uff0c\u91cd\u8bd5", e);
                continue;
            }
            break;
        }
        if (isSend) {
            ListenerConf.Position.Builder retBuilder = this.lastGtidOver.clone();
            return retBuilder;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addData(Rule rule, ListenerConf.DuckulaEvent event) {
        Pair curEvent = Pair.of((Object)event, DuckulaAssit.getAddColValues(event, AddColNameType.all_ori));
        if (this.overCallBack != null) {
            AbsConsumerListener absConsumerListener = this;
            synchronized (absConsumerListener) {
                this.getEventList(rule).add((Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>)curEvent);
            }
        } else {
            this.getEventList(rule).add((Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>)curEvent);
        }
        this.itemNum += event.getItemsCount();
        this.lastGtid.setGtids(event.getGtid());
        this.lastGtid.setTime(event.getCommitTime());
        this.lastGtid.setTimeStr(DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(event.getCommitTime()));
        Conf.overProp((String[])new String[]{"batch.running.configKey", "true"});
    }

    private List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>> getEventList(Rule rule) {
        if (!this.sendDataCase.containsKey(rule)) {
            this.sendDataCase.put(rule, new ArrayList());
        }
        return this.sendDataCase.get(rule);
    }

    private synchronized boolean doBusiTrueSync(boolean isTime) throws InterruptedException {
        if (this.itemNum == 0) {
            return true;
        }
        boolean canSend = true;
        if (this.asyncPattern == AsyncPattern.all) {
            if (isTime) {
                ((CountDownLatch)this.countDownLatch.getLeft()).countDown();
            } else {
                ((CountDownLatch)this.countDownLatch.getRight()).countDown();
            }
            boolean bl = canSend = ((CountDownLatch)this.countDownLatch.getLeft()).await(1L, TimeUnit.MILLISECONDS) && ((CountDownLatch)this.countDownLatch.getRight()).await(1L, TimeUnit.MILLISECONDS);
        }
        if (canSend) {
            if (this.isMerge) {
                ArrayList<String> keys = new ArrayList<String>();
                Iterator<Map.Entry<Rule, List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>>>> it = this.sendDataCase.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Rule, List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>>> item = it.next();
                    List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>> data = item.getValue();
                    for (int i = data.size() - 1; i >= 0; --i) {
                        ListenerConf.DuckulaEvent.Builder eventBuilder = ((ListenerConf.DuckulaEvent)data.get(i).getLeft()).toBuilder();
                        boolean isDel = false;
                        for (int j = eventBuilder.getItemsCount() - 1; j >= 0; --j) {
                            String keystr = String.format("%s:%s:%s", eventBuilder.getDb(), eventBuilder.getTb(), DuckulaAssit.getKeyJoin(eventBuilder, j, "~"));
                            if (keys.contains(keystr)) {
                                eventBuilder.removeItems(j);
                                isDel = true;
                                continue;
                            }
                            keys.add(keystr);
                        }
                        if (eventBuilder.getItemsCount() == 0) {
                            data.remove(i);
                            continue;
                        }
                        if (!isDel) continue;
                        Pair pair = Pair.of((Object)eventBuilder.build(), (Object)data.get(i).getRight());
                        data.set(i, (Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>)pair);
                    }
                    if (!CollectionUtils.isEmpty(data)) continue;
                    it.remove();
                }
            }
            this.doBusiAsyncTrue(this.isSplit, this.logicDel, this.sendDataCase);
            Conf.overProp((String[])new String[]{"batch.running.configKey", "false"});
            this.lastGtidOver = this.lastGtid;
            if (this.asyncPattern == AsyncPattern.all) {
                this.countDownLatch = Pair.of((Object)new CountDownLatch(1), (Object)new CountDownLatch(1));
            }
            this.sendDataCase.clear();
            this.curTime = System.currentTimeMillis();
            this.itemNum = 0;
        }
        if (this.overCallBack != null) {
            this.overCallBack.callback(canSend);
        }
        return canSend;
    }

    public void doBusiTrueOne(Rule rule, ListenerConf.DuckulaEvent duckulaEvent, Map<AddColName, Serializable> addValues, boolean isSplit, boolean logicDel) {
        HashMap<Rule, List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase = new HashMap<Rule, List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>>>();
        ArrayList<Pair> datas = new ArrayList<Pair>();
        datas.add(Pair.of((Object)duckulaEvent, addValues));
        sendDataCase.put(rule, datas);
        this.doBusiAsyncTrue(isSplit, logicDel, sendDataCase);
    }

    public abstract void doBusiAsyncTrue(boolean var1, boolean var2, Map<Rule, List<Pair<ListenerConf.DuckulaEvent, Map<AddColName, Serializable>>>> var3);

    @Override
    public void close() {
    }
}

