/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.binlog.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.EasyUiAssist;
import net.wicp.tams.common.apiext.json.easyuibean.EasyUINode;
import net.wicp.tams.common.apiext.json.easyuibean.EasyUINodeConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.constant.FilterPattern;
import net.wicp.tams.common.constant.DrdsPattern;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleManager {
    private static final Logger log = LoggerFactory.getLogger(RuleManager.class);
    private final List<Rule> rules;

    public RuleManager(String rulesstr) {
        this.rules = this.buildRules(rulesstr);
        for (Rule rule : this.rules) {
            if (!rule.getItems().containsKey((Object)RuleItem.parent) || !StringUtil.isNotNull((Object)rule.getItems().get((Object)RuleItem.parent))) continue;
            String[] dbtbary = StringUtil.trimSpace((String)rule.getItems().get((Object)RuleItem.parent)).split(":");
            Rule parent = this.findRuleByPattern(dbtbary[0], dbtbary[1]);
            if (parent == null || parent.equals(rule)) {
                rule.setParent(null);
                continue;
            }
            rule.setParent(parent);
            parent.getSubRules().add(rule);
        }
    }

    public RuleManager(JSONArray rulesJsonAry) {
        this.rules = new ArrayList<Rule>();
        if (rulesJsonAry == null || rulesJsonAry.size() == 0) {
            return;
        }
        for (int i = 0; i < rulesJsonAry.size(); ++i) {
            Rule rule = new Rule();
            JSONObject tempObj = rulesJsonAry.getJSONObject(i);
            String drds = tempObj.containsKey((Object)"drds") ? StringUtil.trimSpace((String)tempObj.getString("drds")) : "";
            String dbPattern = tempObj.containsKey((Object)"dbPattern") ? StringUtil.trimSpace((String)tempObj.getString("dbPattern")) : "";
            String tbPattern = tempObj.containsKey((Object)"tbPattern") ? StringUtil.trimSpace((String)tempObj.getString("tbPattern")) : "";
            rule.setDbPattern(dbPattern);
            rule.setTbPattern(tbPattern);
            rule.setDrds(DrdsPattern.find((String)drds));
            for (RuleItem ruleItem : RuleItem.values()) {
                String value;
                if (!tempObj.containsKey((Object)ruleItem.name()) || !StringUtil.isNotNull((Object)(value = tempObj.getString(ruleItem.name())))) continue;
                rule.getItems().put(ruleItem, value);
            }
            if (tempObj.containsKey((Object)"filter")) {
                try {
                    JSONArray parseArray = tempObj.getJSONArray("filter");
                    rule.putRuleFilter(parseArray);
                }
                catch (Exception e) {
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_undefined, "\u8fc7\u6ee4\u89c4\u5219\u9519\u8bef\uff0c\u8bf7\u4ece\u201c\u8fc7\u6ee4\u5668\u201d\u6309\u94ae\u8fdb\u884c\u7f16\u8f91\u3002");
                }
            }
            this.rules.add(rule);
        }
        for (Rule rule : this.rules) {
            if (!rule.getItems().containsKey((Object)RuleItem.parent) || !StringUtil.isNotNull((Object)rule.getItems().get((Object)RuleItem.parent))) continue;
            String[] dbtbary = StringUtil.trimSpace((String)rule.getItems().get((Object)RuleItem.parent)).split(":");
            Rule parent = this.findRuleByPattern(dbtbary[0], dbtbary[1]);
            if (parent == null || parent.equals(rule)) {
                rule.setParent(null);
                continue;
            }
            rule.setParent(parent);
            parent.getSubRules().add(rule);
        }
    }

    private List<Rule> buildRules(String rules) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (StringUtil.isNull((Object)rules)) {
            return ruleList;
        }
        String[] ruleAry = rules.split("&");
        ArrayList<String[]> ruleDoAfter = new ArrayList<String[]>();
        for (String rule : ruleAry) {
            String[] ruleValues = rule.split("`", 5);
            if (ruleValues.length == 0 || ruleValues.length != 5) {
                throw new IllegalArgumentException("\u89c4\u5219\u957f\u5ea6\u53ea\u80fd\u4e3a5!");
            }
            if (ruleValues[0].equals("^*$") || ruleValues[1].equals("^*$")) {
                ruleDoAfter.add(ruleValues);
                continue;
            }
            String[] dbs = ruleValues[0].split("\\|");
            String[] tbs = ruleValues[1].split("\\|");
            for (int i = 0; i < dbs.length; ++i) {
                for (int j = 0; j < tbs.length; ++j) {
                    String[] tempAry = (String[])ruleValues.clone();
                    tempAry[0] = dbs[i].replaceAll("^", "").replaceAll("$", "");
                    tempAry[1] = tbs[j].replaceAll("^", "").replaceAll("$", "");
                    ruleDoAfter.add(tempAry);
                }
            }
        }
        for (String[] ruleValues : ruleDoAfter) {
            Rule rule = new Rule();
            String itemStr = null;
            String filterStr = null;
            if (StringUtil.isNotNull((Object)ruleValues[2])) {
                rule.setDrds(DrdsPattern.find((String)ruleValues[2]));
            }
            itemStr = ruleValues[3];
            if (ruleValues.length == 5) {
                filterStr = ruleValues[4];
            }
            if (rule.getDrds() == null) {
                rule.setDrds(DrdsPattern.no);
            }
            if (DrdsPattern.no != rule.getDrds()) {
                rule.setDbPattern(String.format(rule.getDrds().getDbPatternFormat(), ruleValues[0]));
            } else {
                rule.setDbPattern(StringUtil.buildRule((String)ruleValues[0]));
            }
            rule.setDbLength(ruleValues[0].length());
            String tbpatternstr = StringUtil.buildRule((String)ruleValues[1]);
            if (DrdsPattern.no != rule.getDrds()) {
                tbpatternstr = String.format(rule.getDrds().getTbPatternFormat(), ruleValues[1]);
            }
            rule.setTbPattern(tbpatternstr);
            rule.setTbLength(ruleValues[1].length());
            JSONObject json = JSON.parseObject((String)itemStr);
            for (String key : json.keySet()) {
                RuleItem tempItem = RuleItem.get(key);
                if (tempItem == null) {
                    log.error("\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5key\u4e0e\u53d1\u9001\u8005!");
                    throw new IllegalArgumentException("\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5key\u4e0e\u53d1\u9001\u8005!");
                }
                rule.getItems().put(tempItem, json.getString(key));
            }
            if (StringUtil.isNotNull((Object)filterStr)) {
                JSONArray parseArray = JSON.parseArray((String)filterStr);
                for (int j = 0; j < parseArray.size(); ++j) {
                    JSONObject jsonObject = parseArray.getJSONObject(j);
                    RuleFilter temp = new RuleFilter();
                    if (jsonObject.containsKey((Object)"field")) {
                        temp.setField(jsonObject.getString("field"));
                    }
                    if (!jsonObject.containsKey((Object)"rule") || !jsonObject.containsKey((Object)"ruleValue")) {
                        log.error("\u8fc7\u6ee4\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u9700\u8981\u8bbe\u7f6erule\u548cruleValue!" + jsonObject.toJSONString());
                        throw new IllegalArgumentException("\u8fc7\u6ee4\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u9700\u8981\u8bbe\u7f6erule\u548cruleValue!" + jsonObject.toJSONString());
                    }
                    temp.setFilterPattern(FilterPattern.valueOf(jsonObject.getString("rule")));
                    temp.setRuleValue(jsonObject.getString("ruleValue"));
                    rule.getFilterRules().add(temp);
                }
            }
            ruleList.add(rule);
        }
        return ruleList;
    }

    public Rule findRule(String db, String tb) {
        if (db.equals(Conf.get((String)"common.binlog.alone.binlog.global.chk.mysql.defaultdb"))) {
            return null;
        }
        for (Rule rule : this.getRules()) {
            boolean rettb;
            boolean retdb;
            if (!"^*$".equals(rule.getDbPattern()) && !(retdb = StrPattern.checkStrFormat((String)rule.getDbPattern(), (String)db)) || !"^*$".equals(rule.getTbPattern()) && !(rettb = StrPattern.checkStrFormat((String)rule.getTbPattern(), (String)tb))) continue;
            return rule;
        }
        return null;
    }

    public Rule findRuleByPattern(String dbPattern, String tbPattern) {
        Rule tempobj = new Rule();
        tempobj.setDbPattern(dbPattern);
        tempobj.setTbPattern(tbPattern);
        int indexOf = this.rules.indexOf(tempobj);
        return indexOf < 0 ? null : this.rules.get(indexOf);
    }

    public List<EasyUINode> getRuleTreeRoot() {
        try {
            EasyUINodeConf conf = new EasyUINodeConf("id", "text", "parent");
            List roots = EasyUiAssist.getTreeRoot(this.rules, (EasyUINodeConf)conf);
            return roots;
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "\u5f97\u5230rule\u7684\u6811\u9519\u8bef");
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.rules.size(); ++i) {
            buff.append("&");
            Rule rule = this.rules.get(i);
            buff.append(rule.getDbOri() + "`");
            buff.append(rule.getTbOri() + "`");
            buff.append(rule.getDrds().name() + "`");
            JSONObject jsontrue = rule.buildRuleItem();
            buff.append(JSONObject.toJSONString((Object)jsontrue, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes}));
            buff.append("`");
            JSONArray ruleFilters = rule.buildRuleFilter();
            buff.append(ruleFilters.size() == 0 ? "" : ruleFilters.toString());
        }
        String retstr = buff.length() > 1 ? buff.substring(1) : "";
        return retstr;
    }

    public void addRule(Rule rule) {
        if (!this.rules.contains(rule)) {
            this.rules.add(rule);
        }
    }

    public JSONArray toJsonAry() {
        JSONArray retAry = new JSONArray();
        for (Rule rule : this.rules) {
            JSONObject jsontrue = rule.buildRule();
            retAry.add((Object)jsontrue);
        }
        return retAry;
    }

    public boolean isValid(String db, String tb) {
        return this.findRule(db, tb) != null;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleManager)) {
            return false;
        }
        RuleManager other = (RuleManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }
}

