/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.callback.IDbTbConvert;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAssit {
    private static final Logger log = LoggerFactory.getLogger(PluginAssit.class);
    private static Map<Rule, ListenerConf.DuckulaEvent.Builder> baseBuilder = new HashMap<Rule, ListenerConf.DuckulaEvent.Builder>();

    public static ListenerConf.ColHis convertCosHis(String host, String db, String tb, long time, List<MySqlColBean> colList, YesOrNo isRds) {
        ListenerConf.ColHis.Builder ColHisBuilder = ListenerConf.ColHis.newBuilder();
        ColHisBuilder.setTime(time);
        ColHisBuilder.setTimeStr(DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(time == -1L ? System.currentTimeMillis() : time * 1000L));
        ColHisBuilder.setServerIp(host);
        ColHisBuilder.setDb(db);
        ColHisBuilder.setTb(tb);
        ArrayList<String> namelist = new ArrayList<String>();
        ArrayList<String> datatypelist = new ArrayList<String>();
        ArrayList<String> coltypelist = new ArrayList<String>();
        ArrayList<Integer> keyindexList = new ArrayList<Integer>();
        for (int i = 0; i < colList.size(); ++i) {
            MySqlColBean ele = colList.get(i);
            namelist.add(ele.getColumnNameStandard(FieldFormart.ori));
            datatypelist.add(ele.getDataType());
            coltypelist.add(ele.getColumnType());
            if (!ele.isPri()) continue;
            keyindexList.add(i);
        }
        if (YesOrNo.yes == isRds && CollectionUtils.isEmpty(keyindexList)) {
            namelist.add("_rowkey_");
            datatypelist.add("varchar");
            coltypelist.add("varchar(255)");
            keyindexList.add(namelist.size() - 1);
        }
        ColHisBuilder.addAllCols(namelist);
        ColHisBuilder.addAllColTypes(datatypelist);
        ColHisBuilder.addAllColTypes2(coltypelist);
        ColHisBuilder.addAllKeyIndex(keyindexList);
        ListenerConf.ColHis retobj = ColHisBuilder.build();
        return retobj;
    }

    public static String toJsonStr(Message message) {
        String json = new JsonFormat().printToString(message);
        return json;
    }

    public static String getKeySplitNo(String db, String tb) {
        String kafkaKey = String.format("%s|%s|%s", db, tb, DateFormatCase.yyyyMMddHHmmss.getInstanc().format(System.currentTimeMillis()));
        return kafkaKey;
    }

    public static JSONObject getKeySplit(List<Pair<String, Serializable>> keyValues) {
        JSONObject retjson = new JSONObject();
        for (Pair<String, Serializable> keyValue : keyValues) {
            retjson.put((String)keyValue.getLeft(), (Object)String.valueOf(keyValue.getRight()));
        }
        return retjson;
    }

    public static <T extends Message> T toMessage(String jsonstr, Class<T> clazz) {
        if (StringUtil.isNull((Object)jsonstr) || clazz == null) {
            return null;
        }
        if (jsonstr.startsWith("\"")) {
            jsonstr = jsonstr.substring(1);
        }
        if (jsonstr.endsWith("\"")) {
            jsonstr = jsonstr.substring(0, jsonstr.length() - 1);
        }
        jsonstr = jsonstr.replace("\\\"", "\"");
        try {
            Message.Builder builder = (Message.Builder)ReflectAssist.invokeStaticMothed((String)clazz.getName(), (String)"newBuilder", (Object[])new Object[0]);
            new JsonFormat().merge((CharSequence)jsonstr, ExtensionRegistry.newInstance(), builder);
            return (T)builder.build();
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static List<String> getJdbcPluginDataSourceConf() {
        Map preGroup = Conf.getPreGroup((String)"common.binlog.alone.plugin.jdbc.", (String[])new String[0]);
        ArrayList<String> retlist = new ArrayList<String>();
        for (String dbinstanceid : preGroup.keySet()) {
            Properties prop = new Properties();
            for (String key : ((Map)preGroup.get(dbinstanceid)).keySet()) {
                prop.put(String.format("common.jdbc.datasource.%s.%s", dbinstanceid, key), ((Map)preGroup.get(dbinstanceid)).get(key));
            }
            Conf.overProp((Properties)prop);
            retlist.add(dbinstanceid);
        }
        return retlist;
    }

    public static Map<Rule, ListenerConf.DuckulaEvent> proCascadeDatas(Connection connection, ListenerConf.DuckulaEvent duckulaEvent, int index, Rule rule) {
        if (CollectionUtils.isNotEmpty(rule.getSubRules()) && (duckulaEvent.getOptType() == ListenerConf.OptType.update || duckulaEvent.getOptType() == ListenerConf.OptType.delete)) {
            String[] relakeyAry = null;
            relakeyAry = rule.getItems().containsKey((Object)RuleItem.relakey) ? rule.getItems().get((Object)RuleItem.relakey).split(",") : DuckulaAssit.getKeyColname(duckulaEvent);
            Object[] relakeyValues = new Object[relakeyAry.length];
            for (int i = 0; i < relakeyValues.length; ++i) {
                relakeyValues[i] = DuckulaAssit.getValue(duckulaEvent, index, relakeyAry[i]);
            }
            HashMap<Rule, ListenerConf.DuckulaEvent> retmap = new HashMap<Rule, ListenerConf.DuckulaEvent>();
            for (Rule subRule : rule.getSubRules()) {
                String packCascadeSql = subRule.packCascadeSql();
                List ress = JdbcAssit.querySqlMapPre((Connection)connection, (String)packCascadeSql, (boolean)false, (Object[])relakeyValues);
                if (CollectionUtils.isEmpty((Collection)ress)) {
                    return null;
                }
                ListenerConf.DuckulaEvent.Builder builder = null;
                if (baseBuilder.containsKey(subRule)) {
                    builder = baseBuilder.get(subRule).clone();
                } else {
                    String db = subRule.getDbOri();
                    String tb = subRule.getTbOri();
                    builder = ListenerConf.DuckulaEvent.newBuilder();
                    builder.setDb(db);
                    builder.setTb(tb);
                    builder.setDbInstanceId(duckulaEvent.getDbInstanceId());
                    builder.setOptType(duckulaEvent.getOptType());
                    String[] primarys = MySqlAssit.getPrimary((Connection)connection, (String)db, (String)tb);
                    Pair needColAndType = MySqlAssit.needColAndType((Connection)connection, (String)db, (String)tb, null, (String)rule.getItems().get((Object)RuleItem.routeColName), (String[])primarys);
                    builder.addAllCols(Arrays.asList((Object[])needColAndType.getLeft()));
                    for (BinlogType binlogType : (BinlogType[])needColAndType.getRight()) {
                        builder.addColsType(ListenerConf.ColumnType.valueOf(binlogType.name()));
                    }
                    builder.setColNum(((String[])needColAndType.getLeft()).length);
                    for (String string : primarys) {
                        int indexOf = ArrayUtils.indexOf((Object[])((Object[])needColAndType.getLeft()), (Object)string);
                        builder.addKeyindexs(indexOf);
                    }
                    builder.setIsError(false);
                    builder.setIsCascade(true);
                    builder.setCommitTime(System.currentTimeMillis());
                    baseBuilder.put(subRule, builder.clone());
                }
                for (Map res : ress) {
                    ListenerConf.DuckulaEventItem.Builder itemBuilder = ListenerConf.DuckulaEventItem.newBuilder();
                    CollectionUtil.filterNull((Map)res, (int)1);
                    itemBuilder.putAllAfter(res);
                    builder.addItems(itemBuilder);
                }
                retmap.put(subRule, builder.build());
            }
            return retmap;
        }
        return null;
    }

    public static Pair<String, String> getNewDbTb(Rule rule, ListenerConf.DuckulaEvent duckulaEvent) {
        String newDb = rule.getItems().get((Object)RuleItem.db);
        String newTb = rule.getItems().get((Object)RuleItem.tb);
        IDbTbConvert dbTbConvert = rule.getDbTbConvert();
        if (dbTbConvert != null) {
            if (StringUtil.isNull((Object)newTb) || "*".equals(newTb)) {
                Pair dbAndTb = dbTbConvert.getDbAndTb(rule.getItems().get((Object)RuleItem.db), Pair.of((Object)duckulaEvent.getDb(), (Object)duckulaEvent.getTb()));
                newDb = (String)dbAndTb.getLeft();
                newTb = (String)dbAndTb.getRight();
            }
        } else {
            if (StringUtil.isNull((Object)newTb)) {
                newTb = duckulaEvent.getTb();
            }
            if (StringUtil.isNull((Object)newDb)) {
                newDb = duckulaEvent.getDb();
            }
        }
        return Pair.of((Object)newDb, (Object)newTb);
    }

    public static void setCheckPoint(ListenerConf.Position.Builder lastGtidOver) {
        Conf.overProp((String[])new String[]{"lastGtidOver.enable", "true", "lastGtidOver.gtid", lastGtidOver.getGtids(), "lastGtidOver.time", String.valueOf(lastGtidOver.getTime()), "lastGtidOver.timeStr", lastGtidOver.getTimeStr()});
    }

    public static void cleanCheckPoint() {
        Conf.overProp((String[])new String[]{"lastGtidOver.enable", "false", "lastGtidOver.gtid", "", "lastGtidOver.time", "", "lastGtidOver.timeStr", ""});
    }

    public static ListenerConf.Position.Builder getCheckPoint() {
        boolean enable = Boolean.parseBoolean(Conf.get((String)"lastGtidOver.enable", (String)"false"));
        if (enable) {
            ListenerConf.Position.Builder newBuilder = ListenerConf.Position.newBuilder();
            newBuilder.setGtids(Conf.get((String)"lastGtidOver.gtid"));
            newBuilder.setTime(Conf.getLong((String)"lastGtidOver.time"));
            newBuilder.setTimeStr(Conf.get((String)"lastGtidOver.timeStr"));
            return newBuilder;
        }
        return null;
    }
}

