/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.dump.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.Data;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.callback.IDbTbConvert;
import net.wicp.tams.common.constant.FieldFormart;

/****
 * dump请求的数据和控制信息
 * 
 * @author 偏锋书生
 *
 *         2018年4月26日
 */
@Data
public class DumpEvent {
	private String targetDb;// 20211209 add 要导入的库名
	private String targetTb;// 20211209 add 要导入的表名
	private String beginId;// 开始ID
	private String endId;// 结束ID
	private int dbtbIndex;
	/*
	 * private String db;// 库名 private String tb;// 表名 private String[] cols;// 列名
	 * private BinlogType[] colsType;// 类型
	 */
	private Dump dump;
	private List<Map<String, String>> datas;// 数据
	
	
	public Pair<String, String> getOriDbtb(){
		return this.dump.getDbtbs().get(dbtbIndex);
	}

	/***
	 * 得到key
	 * 
	 * @param data
	 * @param splitChat
	 * @return
	 */
	public String findKey(Map<String, String> data, String splitChat) {
		if (this.dump == null || MapUtils.isEmpty(data)) {
			return "";
		}
		String[] keyColNames = this.dump.getPrimarys();
		List<String> keyvalues = new ArrayList<String>();
		for (String keyColName : keyColNames) {
			keyvalues.add(data.get(keyColName));
		}
		return CollectionUtil.listJoin(keyvalues, StringUtil.hasNull(splitChat, "|"));
	}

	public String findKey(Map<String, String> data) {
		return findKey(data, null);
	}

	/***
	 * 全量数据转为json
	 * 
	 * @param dumpEvent
	 * @return
	 */
	public static JSONObject convertJson(DumpEvent dumpEvent) {
		JSONObject retobj = new JSONObject();
		retobj.put("optType", "select");
		JSONArray items = new JSONArray();
		for (Map<String, String> data : dumpEvent.getDatas()) {
			JSONObject itemobj = new JSONObject();
			itemobj.put("after", data);
			items.add(itemobj);
		}
		retobj.put("items", items);
		return retobj;
	}

	/***
	 * 按要求转换字段名称
	 * 
	 * @param fieldFormart
	 */
	public void convertEvent(FieldFormart fieldFormart, IDbTbConvert dbTbConvert, Pair<String, String> dbtbOri) {
		this.getDump().getRule().getItems().get(RuleItem.db);
		if (dbTbConvert != null) {
			Pair<String, String> dbAndTb = dbTbConvert.getDbAndTb(null, Pair.of(dbtbOri.getLeft(), dbtbOri.getRight()));
			this.targetDb = dbAndTb.getLeft();
			this.targetTb = dbAndTb.getRight();
		}
		if (fieldFormart != null && FieldFormart.ori != fieldFormart) {
			if (ArrayUtils.isNotEmpty(this.dump.getPrimarysLogic())) {
				for (int i = 0; i < this.dump.getPrimarysLogic().length; i++) {
					this.dump.getPrimarysLogic()[i] = fieldFormart.getColName(this.dump.getPrimarysLogic()[i]);
				}
			}
			if (ArrayUtils.isNotEmpty(this.dump.getPrimarys())) {
				for (int i = 0; i < this.dump.getPrimarys().length; i++) {
					this.dump.getPrimarys()[i] = fieldFormart.getColName(this.dump.getPrimarys()[i]);
				}

			}
			if (ArrayUtils.isNotEmpty(this.dump.getNeedCols())) {
				for (int i = 0; i < dump.getNeedCols().length; i++) {
					this.dump.getNeedCols()[i] = fieldFormart.getColName(this.dump.getNeedCols()[i]);
				}
			}

			// 数据处理
			List<Map<String, String>> newDatas = new ArrayList<Map<String, String>>();
			for (int i = 0; i < this.datas.size(); i++) {
				Map<String, String> newmap = new HashMap<String, String>();
				Map<String, String> oldmap = this.datas.get(i);
				for (String key : oldmap.keySet()) {
					newmap.put(fieldFormart.getColName(key), oldmap.get(key));
				}
				newDatas.add(newmap);
			}
			this.datas = newDatas;
		}

	}
}
