/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.binlog.listener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.Config;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent.Builder;
import net.wicp.tams.common.binlog.alone.ListenerConf.Position;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.constant.AsyncPattern;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.constant.ods.AddColNameType;

@Slf4j
public abstract class AbsConsumerListener implements IConsumerListener {
	// 初始化的参数
	private final boolean logicDel = Conf.getBoolean("common.binlog.alone.binlog.global.logicDel").booleanValue();
	private final FieldFormart fieldFormart = Conf.getEnum(FieldFormart.class,
			"common.binlog.alone.global.fieldFormart");
	protected FieldFormart getFieldFormart() {
		return fieldFormart;
	}

	private final AsyncPattern asyncPattern = Conf.getEnum(AsyncPattern.class,
			"common.binlog.alone.global.async.pattern", AsyncPattern.no);
	private boolean isSplit;
	private boolean isMerge = Conf.getEnum(YesOrNo.class, "common.binlog.alone.global.async.merge",
			YesOrNo.yes) == YesOrNo.yes;
	private final long maxTime = Long.parseLong(Conf.get("common.binlog.alone.global.async.time", "0")) * 1000;
	private final int num = Integer.parseInt(Conf.get("common.binlog.alone.global.async.num", "0"));
	// end 初始化的参数
	private Map<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase = new HashMap<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>>();

	private Pair<CountDownLatch, CountDownLatch> countDownLatch = Pair.of(new CountDownLatch(1), new CountDownLatch(1));

	private long curTime = System.currentTimeMillis();

	private int itemNum = 0;// 数量

	private final Position.Builder lastGtid = Position.newBuilder();// 已读取的GTID

	private Position.Builder lastGtidOver;// 已处理完的GTID

	private ICallback overCallBack;

	public void setOverCallBack(ICallback overCallBack) {
		this.overCallBack = overCallBack;
	}

	public AbsConsumerListener() {
		if (maxTime > 0 && (asyncPattern == AsyncPattern.time || asyncPattern == AsyncPattern.all
				|| asyncPattern == AsyncPattern.one)) {
			ScheduledExecutorService timerService = Executors.newSingleThreadScheduledExecutor();
			timerService.scheduleAtFixedRate(new Runnable() {
				@Override
				public void run() {
					while (true) {
						try {
							long runTime = System.currentTimeMillis();
							if (runTime - curTime >= maxTime) {// 满足条件了
								curTime=runTime;
								boolean isSended = doBusiTrueSync(true);
								if (isSended && lastGtidOver != null) {
									PluginAssit.setCheckPoint(lastGtidOver.clone());// 只能放到全局变量里传值
								}
							}
							break;
						} catch (Throwable e) {
							boolean reDoWait = TimeAssist.reDoWait("common-binlog-alone_Listener", 5);
							if (reDoWait) {
								log.error("发送失败，已达5次上限，退出虚拟机", e);
								LoggerUtil.exit(JvmStatus.s15);
							} else {
								log.error("发送失败，重试", e);
							}
						}
					}
				}
			}, 1, 1, TimeUnit.SECONDS);
		}
	}

	@Override
	public final Position.Builder doBui(Rule rule, DuckulaEvent duckulaEvent, boolean isSplit) {
		boolean isSend = false;
		while (true) {
			try {
				this.isSplit = isSplit;
				DuckulaEvent event = DuckulaAssit.convertEvent(duckulaEvent, this.fieldFormart);
				switch (this.asyncPattern) {
				case no:
					Map<AddColName, Serializable> addValues = DuckulaAssit.getAddColValues(duckulaEvent, AddColName.addColType);
					doBusiTrueOne(rule, event, addValues, isSplit, this.logicDel);
					break;
				case num:
				case one:
				case all:
					addData(rule, event);
					if (this.itemNum >= num) {
						isSend = doBusiTrueSync(false);
					}
					break;
				case time:// 时间优先,不管速度，注意：如果并发大时会内存崩溃。
					addData(rule, event);
					if (System.currentTimeMillis() - curTime >= maxTime) {// 满足条件了
						isSend = doBusiTrueSync(true);
					}
					break;
				default:
					break;
				}
				break;
			} catch (Throwable e) {
				boolean reDoWait = TimeAssist.reDoWait("common-binlog-alone_Listener", 5);
				if (reDoWait) {
					log.error("发送失败，已达5次上限，退出虚拟机", e);
					LoggerUtil.exit(JvmStatus.s15);
				} else {
					log.error("发送失败，重试", e);
				}
			}
		}

		if (isSend) {
			Position.Builder retBuilder = this.lastGtidOver.clone();
			return retBuilder;// 返回最后的gtid.
		} else {
			return null;
		}
	}

	// 添加数据
	private void addData(Rule rule, DuckulaEvent event) {
		Pair<DuckulaEvent, Map<AddColName, Serializable>> curEvent = Pair.of(event, DuckulaAssit.getAddColValues(event,AddColNameType.all_ori));
		if (overCallBack != null) {// 是异步，也就是说
			synchronized (this) {// doBusiTrueSync方法在做的时候它必须被锁定。
				this.getEventList(rule).add(curEvent);
			}
		} else {
			this.getEventList(rule).add(curEvent);
		}
		this.itemNum += event.getItemsCount();
		// 设置lastGtid的值
		this.lastGtid.setGtids(event.getGtid());// 这批数据最后的gtid,未处理。
		this.lastGtid.setTime(event.getCommitTime());// 组装时已经乘已了1000，
		this.lastGtid.setTimeStr(DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(event.getCommitTime()));
		Conf.overProp(Config.batchRunningConfigKey, "true");// 设置批次为running
	}

//	private class TamsData{
//		public TamsData(Pair<DuckulaEvent, Map<AddColName, Serializable>> event) {
//			this.event=event;
//			this.index=new HashMap<String, Integer>();
//			DuckulaEvent curevent = event.getLeft();
//			for (int i = 0; i < curevent.getItemsCount(); i++) {
//				String key = getKey(curevent, i);
//				this.index.put(key, i);
//			}
//		}
//		@Getter
//		private final Pair<DuckulaEvent, Map<AddColName, Serializable>> event;
//		@Getter
//		private final String[] keyArray;
//	}

	private List<Pair<DuckulaEvent, Map<AddColName, Serializable>>> getEventList(Rule rule) {
		if (!this.sendDataCase.containsKey(rule)) {
			this.sendDataCase.put(rule, new ArrayList<Pair<DuckulaEvent, Map<AddColName, Serializable>>>());
		}
		return this.sendDataCase.get(rule);
	}

	// 同步执行发送任务
	private synchronized boolean doBusiTrueSync(boolean isTime) throws InterruptedException {
		if (this.itemNum == 0) {
			return true;// position位置需要移动
		}
		boolean canSend = true;
		if (this.asyncPattern == AsyncPattern.all) {
			if (isTime) {
				this.countDownLatch.getLeft().countDown();
			} else {
				this.countDownLatch.getRight().countDown();
			}
			canSend = this.countDownLatch.getLeft().await(1, TimeUnit.MILLISECONDS)
					&& this.countDownLatch.getRight().await(1, TimeUnit.MILLISECONDS);
		}
		if (canSend) {
			if (this.isMerge) {// 过滤重复的数据
				List<String> keys = new ArrayList<String>();
				// 通过for (Rule rule : this.sendDataCase.keySet())不能删除
				// https://blog.csdn.net/weixin_43999327/article/details/114069331
				for (Iterator<Map.Entry<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>>> it = this.sendDataCase
						.entrySet().iterator(); it.hasNext();) {
					Map.Entry<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>> item = it.next();
					List<Pair<DuckulaEvent, Map<AddColName, Serializable>>> data = item.getValue();
					//重要：后后面开始找，防止出现新数据被删除，旧数据保留的情况。	
					for (int i = data.size() - 1; i >= 0; i--) {
						Builder eventBuilder = data.get(i).getLeft().toBuilder();
						boolean isDel = false;
						for (int j = eventBuilder.getItemsCount() - 1; j >= 0; j--) {
							String keystr = String.format("%s:%s:%s", eventBuilder.getDb(), eventBuilder.getTb(),
									DuckulaAssit.getKeyJoin(eventBuilder, j, "~"));
							if (keys.contains(keystr)) {
								eventBuilder.removeItems(j);
								isDel = true;
							} else {
								keys.add(keystr);
							}
						}
						if (eventBuilder.getItemsCount() == 0) {
							data.remove(i);
						} else {
							if (isDel) {
								Pair<DuckulaEvent, Map<AddColName, Serializable>> pair = Pair.of(eventBuilder.build(),
										data.get(i).getRight());
								data.set(i, pair);
							}
						}
					}
					if (CollectionUtils.isEmpty(data)) {// 没有值就删除
						it.remove();
					}
					// 引用不需要更次更新
//					else{
//						item.setValue(data);
//					}
				}
			}
			doBusiAsyncTrue(this.isSplit, this.logicDel, this.sendDataCase);
			Conf.overProp(Config.batchRunningConfigKey, "false");// 设置状态为批次结束
			this.lastGtidOver = this.lastGtid;
			if (this.asyncPattern == AsyncPattern.all) {
				// 创建了新的阀值
				this.countDownLatch = Pair.of(new CountDownLatch(1), new CountDownLatch(1));
			}
			this.sendDataCase.clear();
			// 时间也需要清零
			this.curTime = System.currentTimeMillis();
			this.itemNum = 0;
		}
		if (this.overCallBack != null) {// 如果有回调对象
			overCallBack.callback(canSend);
		}
		return canSend;// 只要有发送，position位置需要移动
	}

	/***
	 * 
	 * @param rule
	 * @param duckulaEvent
	 * @param addValues    需要附加的字段，如committime，opttype等，见AddColName类
	 * @param isSplit
	 * @param logicDel     是否逻辑删除，true：采用逻辑删除, false：采用物理删除
	 */
	public void doBusiTrueOne(Rule rule, DuckulaEvent duckulaEvent, Map<AddColName, Serializable> addValues,
			boolean isSplit, boolean logicDel) {
		Map<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase = new HashMap<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>>();
		List<Pair<DuckulaEvent, Map<AddColName, Serializable>>> datas = new ArrayList<Pair<DuckulaEvent, Map<AddColName, Serializable>>>();
		datas.add(Pair.of(duckulaEvent, addValues));
		sendDataCase.put(rule, datas);
		doBusiAsyncTrue(isSplit, logicDel, sendDataCase);
	}

	/***
	 * 缓存一批数据发送
	 * 
	 * @param isSplit
	 * @param logicDel
	 * @param sendDataCase
	 */
	public abstract void doBusiAsyncTrue(boolean isSplit, boolean logicDel,
			Map<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase);

	@Override
	public void close() {
	}
}
