/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.binlog.listener;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.jdbc.JdbcConnection;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;
import net.wicp.tams.common.callback.IDbTbConvert;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

@Slf4j
public abstract class AbsBinlogListener extends AbsConsumerListener implements IBinlogListener {
	// 必须要有index值
	protected RuleManager ruleManager;

	protected ConnConf connConf;

	// 启动的时候偿试做一次表的字段同步
	@Override
	public final void init(ConnConf connConf) {
		this.ruleManager = new RuleManager(connConf.getRule());
		this.connConf = connConf;
		int i = 0;
		// 排队common-jdbc，因为会影响control模块
		String dburl = DbType.mysql.geturl(connConf.getHost(), connConf.getPort());
		Connection mainConn = JdbcConnection.getConnectionMyql(dburl, connConf.getUsername(), connConf.getPassword());// DruidAssit.getConnection(connConf.getConfName());
		for (Rule rule : ruleManager.getRules()) {
			doInit(rule, i++);// 先执行子类的初始化工作，创建Esclient会要它先执行。autocreate工作
			// 再用常用的检查
			List<String[]> allTables = MySqlAssit.getAllTables(mainConn, rule.getDbPattern(), rule.getTbPattern());
			if (CollectionUtils.isNotEmpty(allTables)) {
				List<String> hasPattern = new ArrayList<String>();
				for (String[] dbtb : allTables) {
					if (rule.checkSamePattern(hasPattern, dbtb[0], dbtb[1])) {// 已处理过就不处理了，处理“|”的情况
						continue;
					}
					List<MySqlColBean> colList = MySqlAssit.getColsBean(mainConn, dbtb[0], dbtb[1]);
					ColHis convertCosHis = PluginAssit.convertCosHis(connConf.getHost(), dbtb[0], dbtb[1], -1l, colList,
							connConf.getRds() ? YesOrNo.yes : YesOrNo.no);
					IDbTbConvert dbTbConvert = rule.getDbTbConvert();
					String newTb = dbtb[1];// 默认是原表名
					String newDb = rule.getItems().get(RuleItem.db);
					if (dbTbConvert != null) {// 做了表转换后，变成了新表名
						Pair<String, String> dbAndTb = dbTbConvert.getDbAndTb(null, Pair.of(dbtb[0], dbtb[1]));
						newTb = dbAndTb.getRight();
					}
					try {
						FieldFormart fieldFormart = Conf.getEnum(FieldFormart.class,
								"common.binlog.alone.global.fieldFormart");

						Result doAlterTableCallBack = doAlterTableCallBack(rule, convertCosHis, null, null, null, null,
								fieldFormart, newDb, newTb);// 没办法恢复当时的SQL，只能传
						// null.
						if (doAlterTableCallBack != null && !doAlterTableCallBack.isSuc()) {
							throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail,
									"初始化时，检查同步失败:" + doAlterTableCallBack.getMessage());
						}
					} catch (Exception e) {
						log.error("初始化时，检查同步失败", e);
					}
				}
			}
		}
		try {
			mainConn.close();
		} catch (SQLException e) {
		}
	}

	public abstract void doInit(Rule rule, int index);

}
