/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.binlog.alone.binlog.bean;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.alone.constant.FilterPattern;
import net.wicp.tams.common.callback.IDbTbConvert;
import net.wicp.tams.common.callback.impl.dbtbconvert.DbTbConvertOds;
import net.wicp.tams.common.constant.DrdsPattern;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

@Data
public class Rule {
	private Rule parent;// 父规则，用于像es的这种有关联关系的表
	private String dbPattern;
	private String tbPattern;
	private DrdsPattern drds;// dbtb 分库也分表 db 只分库 no 不分库分表
	// private String splitKey;//
	// private String remark;
	Map<RuleItem, String> items = new HashMap<>();

	final List<RuleFilter> filterRules = new ArrayList<RuleFilter>();

	private int dbLength;

	private int tbLength;

	private String tbOri;

	private String dbOri;

	public List<Rule> subRules = new ArrayList<Rule>();// 子规则

	/***
	 * 检查规则数据是否合规
	 * 
	 * @param middleware
	 */
	public void checkRule(Middleware middleware) {
		if (!ArrayUtils.contains(middleware.getGroups(), "duckularule")) {
			throw new ProjectExceptionRuntime(ExceptAll.param_error, "还不支持此类型[" + middleware.name() + "]");
		}
		Result ret = Result.getSuc();
		switch (middleware) {
		case mysql:
		case sqlserver:
			break;
		case es:
			ret = checkNotNull(RuleItem.index);
			break;
		case http:
			ret = checkNotNull(RuleItem.httpRela);
			break;
		case kafka:
			ret = checkNotNull(RuleItem.topic);
			break;
		default:
			break;
		}
		if (!ret.isSuc()) {
			throw new ProjectExceptionRuntime(ExceptAll.param_error, ret.getMessage());
		}
	}

	private Result checkNotNull(RuleItem... ruleItems) {
		Result ret = Result.getSuc();
		for (RuleItem ruleItem : ruleItems) {
			if (!items.containsKey(ruleItem) || StringUtil.isNull(items.get(ruleItem))) {
				return Result.getError("需要配置[" + ruleItem.getDesc() + "]");
			}
		}
		return ret;
	}

	// 得到表名的转换器
	public IDbTbConvert getDbTbConvert() {
		Boolean enable = Conf.getBoolean("common.binlog.alone.global.dbTbConvert.enable");
		if (enable != null && enable) {
			String tbPre = Conf.get("common.binlog.alone.global.dbTbConvert.tbPre");
			IDbTbConvert dbTbConvert = new DbTbConvertOds(tbPre, this.drds);
			return dbTbConvert;
		}
		return null;
	}

	@Setter(value = AccessLevel.PRIVATE)
	@Getter(value = AccessLevel.PRIVATE)
	private String[] primarys;// 主键，不需要配置，要由程序读数据库得到,适合于单表或一组单表

	// 生成查询SQL
	public String packFromstr() {
		String retsql = "";
		if (containsItem(RuleItem.wheresql)) {
			retsql = this.items.get(RuleItem.wheresql);
			if (!retsql.substring(0, 5).equalsIgnoreCase("where")) {
				retsql = "where " + retsql;
			}
		}
		String fromstr = String.format("from %s %s", String.format("`%s`.`%s`", this.dbOri, this.tbOri),
				StringUtil.isNull(retsql) ? "where 1=1 " : retsql);
		return fromstr;
	}

	/***
	 * 生成级联的SQL
	 * 
	 * @return
	 */
	public String packCascadeSql() {
		String retsql = "";
		if (containsItem(RuleItem.parent) && containsItem(RuleItem.relakey)) {// 现在是子规则了，包有这2个字段才需要做级联查询
			String[] relas = this.items.get(RuleItem.relakey).split(",");
			StringBuffer buf = new StringBuffer(
					String.format("select * from %s.%s where ", this.getDbOri(), this.getTbOri()));
			for (int i = 0; i < relas.length; i++) {
				if (i == 0) {
					buf.append(String.format(" %s=?", relas[i]));
				} else {
					buf.append(String.format(" and %s=?", relas[i]));
				}

			}
			retsql = buf.toString();
		}
		return retsql;
	}

	/**
	 * 设置item值
	 * 
	 * @param ruleItem
	 * @param value
	 */
	public void putRuleItem(RuleItem ruleItem, String value) {
		this.items.put(ruleItem, value);
	}

	public void removeRuleItem(RuleItem ruleItem) {
		if (this.items.containsKey(ruleItem)) {
			this.items.remove(ruleItem);
		}
	}

	public String getRuleItem(RuleItem item) {
		return StringUtil.hasNull(this.items.get(item), "");
	}

	public String[] getPrimarys(Connection conn) {
		if (ArrayUtils.isEmpty(primarys)) {
			this.primarys = MySqlAssit.getPrimary(conn, getDbOri(), getTbOri());
		}
		return this.primarys;
	}

	public String index(String db, String tb) {// TODO
		String[] dbPatternAry = dbPattern.split("\\|");
		String[] tbPatternAry = tbPattern.split("\\|");
		int dbindex = -1, tbindex = -1;
		for (int i = 0; i < dbPatternAry.length; i++) {
			if (StrPattern.checkStrFormat(dbPatternAry[i], db)) {
				dbindex = i;
				break;
			}
		}
		for (int i = 0; i < tbPatternAry.length; i++) {
			if (StrPattern.checkStrFormat(tbPatternAry[i], tb)) {
				tbindex = i;
				break;
			}
		}
		return String.format("%s|%s", dbindex, tbindex);
	}

	// 是否包含了item
	public boolean containsItem(RuleItem ruleItem) {
		return this.items.containsKey(ruleItem) && StringUtil.isNotNull(this.items.get(ruleItem));
	}

	/***
	 * 检查是否已处理的模式
	 * 
	 * @param hasPattern
	 * @param db
	 * @param tb
	 * @return
	 */
	public boolean checkSamePattern(List<String> hasPattern, String db, String tb) {
		String indexstr = index(db, tb);
		if (hasPattern.contains(indexstr)) {
			return true;
		} else {
			hasPattern.add(indexstr);
			return false;
		}
	}

	public JSONObject buildRuleItem() {
		JSONObject retobj = new JSONObject();
		for (RuleItem ruleItem : items.keySet()) {
			retobj.put(ruleItem.name(), items.get(ruleItem));
		}
		return retobj;
	}

	public JSONArray buildRuleFilter() {
		JSONArray jsonAry = new JSONArray();
		for (RuleFilter ruleFilter : this.filterRules) {
			jsonAry.add(ruleFilter.toJson());
		}
		return jsonAry;
	}

	public void putRuleFilter(JSONArray parseArray) {
		this.filterRules.clear();
		if (parseArray != null) {
			for (int j = 0; j < parseArray.size(); j++) {
				JSONObject jsonObject = parseArray.getJSONObject(j);
				RuleFilter temp = new RuleFilter();
				temp.setField(jsonObject.getString("field"));
				temp.setFilterPattern(FilterPattern.valueOf(jsonObject.getString("rule")));
				temp.setRuleValue(jsonObject.getString("ruleValue"));
				this.filterRules.add(temp);
			}
		}
	}

	public JSONObject buildRule() {
		JSONObject retJson = buildRuleItem();
		retJson.put("dbPattern", this.dbPattern);
		retJson.put("tbPattern", this.tbPattern);
		retJson.put("drds", this.drds.name());
		JSONArray ruleFilters = buildRuleFilter();
		retJson.put("filter", ruleFilters.size() == 0 ? "" : ruleFilters.toString());
		return retJson;
	}

	public static String buildOriRuleStr(String ruleStr) {
		String retStr = ruleStr.replaceAll("\\^", "").replaceAll("\\$", "").replaceAll("\\[0-9\\]\\*", "")
				.replaceAll("_\\[0-9a-zA-Z\\]\\{4\\}", "").replaceAll("_\\[0-9\\]\\{2,\\}", "");
		return retStr;
	}

	public String getTbOri() {
		if (tbOri == null) {
			this.tbOri = buildOriRuleStr(tbPattern);
		}
		return this.tbOri;
	}

//
	public String getDbOri() {
		if (dbOri == null) {
			this.dbOri = buildOriRuleStr(dbPattern);
		}
		return this.dbOri;
	}

	@Override
	public boolean equals(Object obj) {
		Rule temp = (Rule) obj;
		return this.getDbOri().equals(temp.getDbOri()) && this.getTbOri().equals(temp.getTbOri());
	}

	@Override
	public int hashCode() {
		return this.getDbOri().hashCode() * 37 + this.getTbOri().hashCode();
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////// 构造树//////////////////////////////////////////
	public String getId() {
		return String.format("`%s`.`%s`", getDbOri(), getTbOri());
	}

	public String getText() {
		return getId();
	}

	public String getParentId() {
		return String.format("`%s`.`%s`", parent.getDbOri(), parent.getTbOri());
	}

}
