package net.wicp.tams.common.binlog.alone.filter.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.MutableTriple;

import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColumnType;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent.Builder;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEventItem;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.filter.IFilter;

/***
 * 未完成
 * 
 * @author Andy
 *
 */
public class FilterForColname implements IFilter {

	private volatile static Map<String, MutableTriple<Integer, Integer[], Integer[]>> removemap = new HashMap<String, MutableTriple<Integer, Integer[], Integer[]>>();// key:db-tb
	// value:L:colssize
	// R:removeindex

	@Override
	public void doFilter(Builder data, Rule rule, RuleFilter filterRulePo) {
		String key = String.format("%s-%s", rule.getDbOri(), rule.getTbOri());
		if (removemap.get(key) == null || removemap.get(key).getLeft() != data.getColNum()) {// 有可能修改了表结构，增加了一列
			synchronized (FilterForColname.class) {
				if (removemap.get(key) == null || removemap.get(key).getLeft() != data.getColNum()) {
					String[] cols = filterRulePo.getRuleValue().split(",");
					String[] primkey = new String[] { data.getCols(0) };
					String[] arrayTrue = CollectionUtil.arrayOr(String[].class, cols, primkey);
					List<Integer> removeIndex = new ArrayList<Integer>();
					List<Integer> saveIndex = new ArrayList<Integer>();
					for (int i = 0; i < data.getColsCount(); i++) {
						if (!ArrayUtils.contains(arrayTrue, data.getCols(i))) {
							removeIndex.add(i);
						} else {
							saveIndex.add(i);
						}
					}
					removemap.put(key,
							MutableTriple.of(data.getColsCount(), removeIndex.toArray(new Integer[removeIndex.size()]),
									saveIndex.toArray(new Integer[saveIndex.size()])));
				}
			}
		}
		for (int i = data.getItemsCount() - 1; i >= 0; i--) {
			DuckulaEventItem.Builder itemBuild = data.getItemsBuilder(i);
			if (itemBuild.getAfterCount() != 0) {
				for (Integer remove : removemap.get(key).getMiddle()) {
					itemBuild.removeAfter(data.getColsList().get(remove));
				}
			}
			if (itemBuild.getBeforeCount() != 0) {
				for (Integer remove : removemap.get(key).getMiddle()) {
					itemBuild.removeBefore(data.getColsList().get(remove));
				}
			}
		}
		// 先去除详单，再设置其它配置，顺序不能变
		data.setColNum(removemap.get(key).getRight().length);
		String[] cols = data.getColsList().toArray(new String[data.getColsList().size()]);
		ColumnType[] types = data.getColsTypeList().toArray(new ColumnType[data.getColsTypeList().size()]);
		data.clearCols();
		data.clearColsType();
		for (int i = 0; i < removemap.get(key).getRight().length; i++) {
			Integer index = removemap.get(key).getRight()[i];
			data.addCols(cols[index]);
			data.addColsType(types[index]);
		}
		data.setIsError(true);
	}

	@Override
	public void doFilter(DumpEvent data, Rule rule, RuleFilter filterRulePo) {
		// 设置需要导出的列：needCols就OK,就是设置RuleItem.needCols
		// 不支持
		return;

	}
}
