package net.wicp.tams.common.binlog.alone.dump.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.Data;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;

/****
 * dump请求的数据和控制信息
 * 
 * @author 偏锋书生
 *
 *         2018年4月26日
 */
@Data
public class DumpEvent {
	private String beginId;// 开始ID
	private String endId;// 结束ID
	/*
	 * private String db;// 库名 private String tb;// 表名 private String[] cols;// 列名
	 * private BinlogType[] colsType;// 类型
	 */
	private Dump dump;
	private List<Map<String, String>> datas;// 数据

	/***
	 * 得到key
	 * 
	 * @param data
	 * @param splitChat
	 * @return
	 */
	public String findKey(Map<String, String> data, String splitChat) {
		if (this.dump == null || MapUtils.isEmpty(data)) {
			return "";
		}
		String[] keyColNames = this.dump.getPrimarys();
		List<String> keyvalues = new ArrayList<String>();
		for (String keyColName : keyColNames) {
			keyvalues.add(data.get(keyColName));
		}
		return CollectionUtil.listJoin(keyvalues, StringUtil.hasNull(splitChat, "|"));
	}

	public String findKey(Map<String, String> data) {
		return findKey(data, null);
	}

	/***
	 * 全量数据转为json
	 * 
	 * @param dumpEvent
	 * @return
	 */
	public static JSONObject convertJson(DumpEvent dumpEvent) {
		JSONObject retobj = new JSONObject();
		retobj.put("optType", "select");
		JSONArray items = new JSONArray();
		for (Map<String, String> data : dumpEvent.getDatas()) {
			JSONObject itemobj = new JSONObject();
			itemobj.put("after", data);
			items.add(itemobj);
		}
		retobj.put("items", items);
		return retobj;
	}
}
