package net.wicp.tams.common.binlog.alone.binlog.bean;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.alone.constant.FilterPattern;
import net.wicp.tams.common.constant.StrPattern;

@Data
public class Rule {
	private String dbPattern;
	private String tbPattern;
	private String drds;// dbtb 分库也分表 db 只分库 no 不分库分表
	// private String splitKey;//
	// private String remark;
	Map<RuleItem, String> items = new HashMap<>();
	
	
	final List<RuleFilter> filterRules=new ArrayList<RuleFilter>();

	public static String drdsTbPatternFormat1 = "^%s_[0-9a-zA-Z]{4}";

	public static String drdsTbPatternFormat2 = "^%s_[0-9a-zA-Z]{4}_[0-9]{2,}$";

	private int dbLength;

	private int tbLength;

	private String tbOri;

	private String dbOri;

	@Setter(value = AccessLevel.PRIVATE)
	@Getter(value = AccessLevel.PRIVATE)
	private String[] primarys;// 主键，不需要配置，要由程序读数据库得到,适合于单表或一组单表

	// 生成查询SQL
	public String packFromstr() {
		String retsql = "";
		if (containsItem(RuleItem.wheresql)) {
			retsql = this.items.get(RuleItem.wheresql);
			if (!retsql.substring(0, 5).equalsIgnoreCase("where")) {
				retsql = "where " + retsql;
			}
		}
		String fromstr = String.format("from %s %s", String.format("`%s`.`%s`", this.dbOri, this.tbOri),
				StringUtil.isNull(retsql) ? "where 1=1 " : retsql);
		return fromstr;
	}
	/**
	 * 设置item值
	 * @param item
	 * @param value
	 */
	public void putRuleItem(RuleItem item,String value) {
		this.items.put(item, value);
	}
	
	public String getRuleItem(RuleItem item) {
		return StringUtil.hasNull(this.items.get(item),"");
	}

	public String[] getPrimarys(Connection conn) {
		if (ArrayUtils.isEmpty(primarys)) {
			this.primarys = MySqlAssit.getPrimary(conn, getDbOri(), getTbOri());
		}
		return this.primarys;
	}

	public String index(String db, String tb) {// TODO
		String[] dbPatternAry = dbPattern.split("\\|");
		String[] tbPatternAry = tbPattern.split("\\|");
		int dbindex = -1, tbindex = -1;
		for (int i = 0; i < dbPatternAry.length; i++) {
			if (StrPattern.checkStrFormat(dbPatternAry[i], db)) {
				dbindex = i;
				break;
			}
		}
		for (int i = 0; i < tbPatternAry.length; i++) {
			if (StrPattern.checkStrFormat(tbPatternAry[i], tb)) {
				tbindex = i;
				break;
			}
		}
		return String.format("%s|%s", dbindex, tbindex);
	}

	// 是否包含了item
	public boolean containsItem(RuleItem ruleItem) {
		return this.items.containsKey(ruleItem) && StringUtil.isNotNull(this.items.get(ruleItem));
	}

	/***
	 * 检查是否已处理的模式
	 * 
	 * @param hasPattern
	 * @param db
	 * @param tb
	 * @return
	 */
	public boolean checkSamePattern(List<String> hasPattern, String db, String tb) {
		String indexstr = index(db, tb);
		if (hasPattern.contains(indexstr)) {
			return true;
		} else {
			hasPattern.add(indexstr);
			return false;
		}
	}

	public JSONObject buildRuleItem() {
		JSONObject retobj = new JSONObject();
		for (RuleItem ruleItem : items.keySet()) {
			retobj.put(ruleItem.name(), items.get(ruleItem));
		}
		return retobj;
	}
	
	public JSONArray buildRuleFilter() {		
		JSONArray jsonAry=new JSONArray();
		for (RuleFilter ruleFilter : this.filterRules) {
			jsonAry.add(ruleFilter.toJson());
		}
		return jsonAry;
	}
	
	public void putRuleFilter(JSONArray parseArray) {
		this.filterRules.clear();
		if (parseArray != null) {
			for (int j = 0; j < parseArray.size(); j++) {
				JSONObject jsonObject = parseArray.getJSONObject(j);
				RuleFilter temp = new RuleFilter();
				temp.setField(jsonObject.getString("field"));
				temp.setFilterPattern(FilterPattern.valueOf(jsonObject.getString("rule")));
				temp.setRuleValue(jsonObject.getString("ruleValue"));
				this.filterRules.add(temp);
			}
		}
	}

	public JSONObject buildRule() {
		JSONObject retJson = buildRuleItem();
		retJson.put("dbPattern", this.dbPattern);
		retJson.put("tbPattern", this.tbPattern);
		retJson.put("drds", this.drds);	
		JSONArray ruleFilters = buildRuleFilter();
		retJson.put("filter", ruleFilters.size()==0?"":ruleFilters.toString());
		return retJson;
	}

	public static String buildOriRuleStr(String ruleStr) {
		String retStr = ruleStr.replaceAll("\\^", "").replaceAll("\\$", "").replaceAll("\\[0-9\\]\\*", "")
				.replaceAll("_\\[0-9a-zA-Z\\]\\{4\\}", "").replaceAll("_\\[0-9\\]\\{2,\\}", "");
		return retStr;
	}

	public String getTbOri() {
		if (tbOri == null) {
			this.tbOri = buildOriRuleStr(tbPattern);
		}
		return this.tbOri;
	}

	public String getDbOri() {
		if (dbOri == null) {
			this.dbOri = buildOriRuleStr(dbPattern);
		}
		return this.dbOri;
	}

	@Override
	public boolean equals(Object obj) {
		Rule temp = (Rule) obj;
		return this.dbPattern.equals(temp.getDbPattern()) && this.tbPattern.equals(temp.getTbPattern());
	}

	@Override
	public int hashCode() {
		return this.dbPattern.hashCode() * 37 + this.tbPattern.hashCode();
	}
}
