/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.filter.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.filter.IFilter;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterForSql
implements IFilter {
    private static final Logger log = LoggerFactory.getLogger(FilterForSql.class);
    private DataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ListenerConf.DuckulaEvent.Builder data, Rule rule, RuleFilter filterRulePo) {
        Connection connection = null;
        Statement prst = null;
        try {
            String[] colNameFormSql = this.getColNameFormSql(filterRulePo.getRuleValue());
            String sql = filterRulePo.getRuleValue();
            for (String tempCol : colNameFormSql) {
                sql = sql.replace(String.format("@{%s}", tempCol), "?");
            }
            for (int i = data.getItemsCount() - 1; i >= 0; --i) {
                ListenerConf.DuckulaEventItem itemBuild = data.getItems(i);
                Map<String, String> datamap = data.getOptType() != ListenerConf.OptType.delete ? itemBuild.getAfterMap() : itemBuild.getBeforeMap();
                Object[] queryParams = new String[colNameFormSql.length];
                boolean isDel = false;
                for (int j = 0; j < colNameFormSql.length; ++j) {
                    String value = datamap.get(colNameFormSql[j]);
                    if (StringUtil.isNull((Object)value)) {
                        data.removeItems(i);
                        isDel = true;
                        break;
                    }
                    queryParams[j] = value;
                }
                if (isDel) continue;
                if (connection == null || connection.isClosed()) {
                    if (this.dataSource == null) {
                        this.dataSource = (DataSource)PerthreadManager.getInstance().createValue((Object)"_curthread", DataSource.class).get(null);
                    }
                    connection = this.dataSource.getConnection();
                    prst = connection.prepareStatement(sql);
                }
                JdbcAssit.setPreParam((PreparedStatement)prst, (Object[])queryParams);
                ResultSet rs = prst.executeQuery();
                if (!rs.next()) {
                    data.removeItems(i);
                    continue;
                }
                rs.close();
            }
        }
        catch (Exception e) {
            log.error("\u8fc7\u6ee4\u5931\u8d25", (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (prst != null) {
                    prst.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private String[] getColNameFormSql(String sql) {
        int j;
        ArrayList<String> retlist = new ArrayList<String>();
        int i = 0;
        while ((j = sql.indexOf("@{", i)) > 0) {
            int k = sql.indexOf("}", j);
            String temp = sql.substring(j + 2, k);
            i = k + 1;
            retlist.add(temp);
        }
        return retlist.toArray(new String[retlist.size()]);
    }

    @Override
    public void doFilter(DumpEvent data, Rule rule, RuleFilter filterRulePo) {
    }
}

