/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.binlog.listener;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.jdbc.JdbcConnection;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsConsumerListener;
import net.wicp.tams.common.binlog.alone.binlog.listener.IBinlogListener;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsBinlogListener
extends AbsConsumerListener
implements IBinlogListener {
    private static final Logger log = LoggerFactory.getLogger(AbsBinlogListener.class);
    protected RuleManager ruleManager;
    protected ListenerConf.ConnConf connConf;

    @Override
    public final void init(ListenerConf.ConnConf connConf) {
        this.ruleManager = new RuleManager(connConf.getRule());
        this.connConf = connConf;
        int i = 0;
        String dburl = DbType.mysql.geturl(connConf.getHost(), connConf.getPort());
        Connection mainConn = JdbcConnection.getConnectionMyql((String)dburl, (String)connConf.getUsername(), (String)connConf.getPassword());
        for (Rule rule : this.ruleManager.getRules()) {
            this.doInit(rule, i++);
            List allTables = MySqlAssit.getAllTables((Connection)mainConn, (String)rule.getDbPattern(), (String)rule.getTbPattern());
            if (!CollectionUtils.isNotEmpty((Collection)allTables)) continue;
            ArrayList<String> hasPattern = new ArrayList<String>();
            for (String[] dbtb : allTables) {
                if (rule.checkSamePattern(hasPattern, dbtb[0], dbtb[1])) continue;
                List colList = MySqlAssit.getColsNew((Connection)mainConn, (String)dbtb[0], (String)dbtb[1], (YesOrNo)(connConf.getRds() ? YesOrNo.yes : YesOrNo.no));
                ListenerConf.ColHis convertCosHis = PluginAssit.convertCosHis(connConf.getHost(), dbtb[0], dbtb[1], -1L, colList);
                try {
                    Result doAlterTableCallBack = this.doAlterTableCallBack(rule, convertCosHis, null, null, null, null);
                    if (doAlterTableCallBack == null || doAlterTableCallBack.isSuc()) continue;
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_exec_fail, "\u521d\u59cb\u5316\u65f6\uff0c\u68c0\u67e5\u540c\u6b65\u5931\u8d25:" + doAlterTableCallBack.getMessage());
                }
                catch (Exception e) {
                    log.error("\u521d\u59cb\u5316\u65f6\uff0c\u68c0\u67e5\u540c\u6b65\u5931\u8d25", (Throwable)e);
                }
            }
        }
        try {
            mainConn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public abstract void doInit(Rule var1, int var2);
}

