/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.binlog.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.constant.FilterPattern;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleManager {
    private static final Logger log = LoggerFactory.getLogger(RuleManager.class);
    private final List<Rule> rules;

    public RuleManager(String rulesstr) {
        this.rules = this.buildRules(rulesstr);
    }

    public RuleManager(JSONArray rulesJsonAry) {
        this.rules = new ArrayList<Rule>();
        if (rulesJsonAry == null || rulesJsonAry.size() == 0) {
            return;
        }
        for (int i = 0; i < rulesJsonAry.size(); ++i) {
            Rule rule = new Rule();
            JSONObject tempObj = rulesJsonAry.getJSONObject(i);
            String drds = tempObj.containsKey((Object)"drds") ? StringUtil.trimSpace((String)tempObj.getString("drds")) : "";
            String dbPattern = tempObj.containsKey((Object)"dbPattern") ? StringUtil.trimSpace((String)tempObj.getString("dbPattern")) : "";
            String tbPattern = tempObj.containsKey((Object)"tbPattern") ? StringUtil.trimSpace((String)tempObj.getString("tbPattern")) : "";
            rule.setDbPattern(dbPattern);
            rule.setTbPattern(tbPattern);
            rule.setDrds(drds);
            for (RuleItem ruleItem : RuleItem.values()) {
                String value;
                if (!tempObj.containsKey((Object)ruleItem.name()) || !StringUtil.isNotNull((Object)(value = tempObj.getString(ruleItem.name())))) continue;
                rule.getItems().put(ruleItem, value);
            }
            if (tempObj.containsKey((Object)"filter")) {
                try {
                    JSONArray parseArray = tempObj.getJSONArray("filter");
                    rule.putRuleFilter(parseArray);
                }
                catch (Exception e) {
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_undefined, "\u8fc7\u6ee4\u89c4\u5219\u9519\u8bef\uff0c\u8bf7\u4ece\u201c\u8fc7\u6ee4\u5668\u201d\u6309\u94ae\u8fdb\u884c\u7f16\u8f91\u3002");
                }
            }
            this.rules.add(rule);
        }
    }

    private List<Rule> buildRules(String rules) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (StringUtil.isNull((Object)rules)) {
            return ruleList;
        }
        String[] ruleAry = rules.split("&");
        for (int i = 0; i < ruleAry.length; ++i) {
            String[] ruleValues = ruleAry[i].split("`", 5);
            if (ruleValues.length == 0 || ruleValues.length != 5) {
                throw new IllegalArgumentException("\u89c4\u5219\u957f\u5ea6\u53ea\u80fd\u4e3a5!");
            }
            Rule rule = new Rule();
            String itemStr = null;
            String filterStr = null;
            boolean isdrds = false;
            if (StringUtil.isNotNull((Object)ruleValues[2])) {
                rule.setDrds(ruleValues[2]);
                isdrds = true;
            }
            itemStr = ruleValues[3];
            if (ruleValues.length == 5) {
                filterStr = ruleValues[4];
            }
            if (isdrds) {
                rule.setDbPattern(String.format(Rule.drdsTbPatternFormat2, ruleValues[0]));
            } else {
                rule.setDbPattern(this.buildPatter(ruleValues[0]));
            }
            rule.setDbLength(ruleValues[0].length());
            String tbpatternstr = this.buildPatter(ruleValues[1]);
            if (isdrds) {
                if ("dbtb".equals(rule.getDrds())) {
                    tbpatternstr = String.format(Rule.drdsTbPatternFormat2, ruleValues[1]);
                } else if ("db".equals(rule.getDrds())) {
                    tbpatternstr = String.format(Rule.drdsTbPatternFormat1, ruleValues[1]);
                } else if ("no".equals(rule.getDrds())) {
                    tbpatternstr = ruleValues[1];
                }
            }
            rule.setTbPattern(tbpatternstr);
            rule.setTbLength(ruleValues[1].length());
            JSONObject json = JSON.parseObject((String)itemStr);
            for (String key : json.keySet()) {
                RuleItem tempItem = RuleItem.get(key);
                if (tempItem == null) {
                    log.error("\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5key\u4e0e\u53d1\u9001\u8005!");
                    throw new IllegalArgumentException("\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5key\u4e0e\u53d1\u9001\u8005!");
                }
                rule.getItems().put(tempItem, json.getString(key));
            }
            if (StringUtil.isNotNull((Object)filterStr)) {
                JSONArray parseArray = JSON.parseArray((String)filterStr);
                for (int j = 0; j < parseArray.size(); ++j) {
                    JSONObject jsonObject = parseArray.getJSONObject(j);
                    RuleFilter temp = new RuleFilter();
                    if (jsonObject.containsKey((Object)"field")) {
                        temp.setField(jsonObject.getString("field"));
                    }
                    if (!jsonObject.containsKey((Object)"rule") || !jsonObject.containsKey((Object)"ruleValue")) {
                        log.error("\u8fc7\u6ee4\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u9700\u8981\u8bbe\u7f6erule\u548cruleValue!" + jsonObject.toJSONString());
                        throw new IllegalArgumentException("\u8fc7\u6ee4\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u9700\u8981\u8bbe\u7f6erule\u548cruleValue!" + jsonObject.toJSONString());
                    }
                    temp.setFilterPattern(FilterPattern.valueOf(jsonObject.getString("rule")));
                    temp.setRuleValue(jsonObject.getString("ruleValue"));
                    rule.getFilterRules().add(temp);
                }
            }
            ruleList.add(rule);
        }
        return ruleList;
    }

    private String buildPatter(String patter) {
        if (patter.endsWith("_")) {
            return String.format("^%s[0-9]*$", patter);
        }
        return String.format("^%s$", patter);
    }

    public Rule findRule(String db, String tb) {
        if (db.equals(Conf.get((String)"common.binlog.alone.binlog.global.chk.mysql.defaultdb"))) {
            return null;
        }
        for (Rule rule : this.getRules()) {
            boolean rettb;
            boolean retdb;
            if (!"^*$".equals(rule.getDbPattern()) && !(retdb = StrPattern.checkStrFormat((String)rule.getDbPattern(), (String)db)) || !"^*$".equals(rule.getTbPattern()) && !(rettb = StrPattern.checkStrFormat((String)rule.getTbPattern(), (String)tb))) continue;
            return rule;
        }
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.rules.size(); ++i) {
            buff.append("&");
            Rule rule = this.rules.get(i);
            buff.append(rule.getDbOri() + "`");
            buff.append(rule.getTbOri() + "`");
            buff.append(StringUtil.hasNull((String[])new String[]{rule.getDrds()}) + "`");
            JSONObject jsontrue = rule.buildRuleItem();
            buff.append(JSONObject.toJSONString((Object)jsontrue, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes}));
            buff.append("`");
            JSONArray ruleFilters = rule.buildRuleFilter();
            buff.append(ruleFilters.size() == 0 ? "" : ruleFilters.toString());
        }
        String retstr = buff.length() > 1 ? buff.substring(1) : "";
        return retstr;
    }

    public JSONArray toJsonAry() {
        JSONArray retAry = new JSONArray();
        for (Rule rule : this.rules) {
            JSONObject jsontrue = rule.buildRule();
            retAry.add((Object)jsontrue);
        }
        return retAry;
    }

    public boolean isValid(String db, String tb) {
        return this.findRule(db, tb) != null;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleManager)) {
            return false;
        }
        RuleManager other = (RuleManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }
}

