package net.wicp.tams.common.binlog.alone.dump.bean;

import com.alibaba.fastjson.JSONObject;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiFilter;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.dbType.BinlogType;

/**
 * dump配置
 * 
 * @author 偏锋书生
 *
 */
@Data
@Builder
public class Dump {
	private String id;
	private String dbPattern;
	private String tbPattern;
	private String dbDemo;
	private String tbDemo;
	private String[] primarysLogic;// 逻辑主键，某些情况下会用它来做为es的docId,如果它定义了就不会使用primarys，如：从表的外键并不是主表的主键的情况
	private String[] primarys;
	private String[] needCols;// 需要导出的列
	private BinlogType[] needColTypes;// 需要导出列的类型
	private int numDuan;
	private String wheresql;// where语句
	private String startId;// 从哪个ID开始导入
	private Long numDump;// 导多少记录数
	private String esSetting;//是否需要nojoin模式
	private IBusiFilter<DumpEvent> busiFilter;
	private IBusiSender<DumpEvent> busiSender;
	private Rule rule;

	// private DumpGroup metric;

	private volatile String lastId;

	private String dbOri;// 去掉模式后的db值
	private String tbOri;// 去掉模式后的tb值

	private JSONObject busiPluginConfig;// 可能会是插件用的扩展属性

	public String getDbOri() {
		if (StringUtil.isNull(dbOri)) {
			this.dbOri = dbDemo;
		}
		return this.dbOri;
	}

	public String getTbOri() {
		if (StringUtil.isNull(tbOri)) {
			this.tbOri = tbDemo;
		}
		return this.tbOri;
	}

	public String packFromstr() {
		if (StringUtil.isNotNull(this.wheresql)) {
			this.wheresql = StringUtil.trimSpace(this.wheresql);
			if (!this.getWheresql().substring(0, 5).equalsIgnoreCase("where")) {
				this.wheresql = "where " + this.wheresql;
			}
		}
		String fromstr = String.format("from %s %s", String.format("`%s`.`%s`", dbDemo, tbDemo),
				StringUtil.isNull(this.getWheresql()) ? "where 1=1 " : this.getWheresql());
		return fromstr;
	}

	public static BinlogType[] convertColumnType(String[] cosTypes) {
		BinlogType[] rettypes = new BinlogType[cosTypes.length];
		for (int i = 0; i < rettypes.length; i++) {
			rettypes[i] = BinlogType.getByName(cosTypes[i]);
		}
		return rettypes;
	}

	/*
	 * @SuppressWarnings("unchecked") public IBusiSender<DumpEvent> getSender() { if
	 * (this.sender == null) { try { IBusiSender<DumpEvent> newInstance =
	 * (IBusiSender<DumpEvent>)
	 * busiSendClass.getConstructor(Dump.class).newInstance(this); this.sender =
	 * newInstance;
	 * 
	 * } catch (Exception e) { throw new RuntimeException("没有实例", e); } } return
	 * this.sender; }
	 */
}
