package net.wicp.tams.common.binlog.alone.binlog.listener;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;

public interface IBinlogListener extends IConsumerListener {
	public void init(ConnConf connConf);

	/****
	 * 当修改表结构时的回调，添加字段（最常见）、也许是修改类型。此地，可以做如动态添加索引字段等动作，如果需要保证调用成功，则需要返回 false
	 * 
	 * @param rule   命中的规则
	 * @param colHis 修改后的表字段
	 * @param sql    修改的sql语句，如果是起动时的初始检查，没办法恢复当时的sql，会传空值，处于监听期会传当时的修改语句，方便插件最大限度地恢复目标中间件的结构
	 * @return
	 */
	public Result doAlterTableCallBack(Rule rule, ColHis colHis, String sql,String[] addColNames,String updateColName,String[] deleteColNames);
}
