/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.filter.IFilter;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForColname;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForFunction;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForOpttype;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForRegular;
import net.wicp.tams.common.binlog.alone.filter.impl.FilterForSql;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FilterPattern {
    opttype("\u64cd\u4f5c\u7c7b\u578b\u8fc7\u6ee4", false, "other", 0, new FilterForOpttype()),
    regular("\u6b63\u5219\u8868\u8fbe\u5f0f", true, "row", 1, new FilterForRegular()),
    sql("\u5e26\u53c2\u6570SQL", false, "row", 2, new FilterForSql()),
    function("\u81ea\u5b9a\u4e49\u51fd\u6570\uff0c\u8003\u8651\u4f7f\u7528\u811a\u672c\u8bed\u8a00", false, "row", 3, new FilterForFunction()),
    colname("\u5217\u540d\u8fc7\u6ee4", false, "col", 999, new FilterForColname());

    private static final Logger log;
    public static final String db_tb_formart = "%s|%s|%s";
    private final String desc;
    private final boolean hasColName;
    private final String group;
    private final int index;
    private final IFilter filter;

    public IFilter getFilter() {
        return this.filter;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDesc() {
        return this.desc;
    }

    private FilterPattern(String desc, boolean hasColName, String group, int index, IFilter filter) {
        this.desc = desc;
        this.hasColName = hasColName;
        this.group = group;
        this.index = index;
        this.filter = filter;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isHasColName() {
        return this.hasColName;
    }

    public static JSONArray getJson(Map<FilterPattern, Map<String, Map<String, Set<String>>>> inputmap) {
        JSONArray retall = new JSONArray();
        if (MapUtils.isEmpty(inputmap)) {
            return retall;
        }
        for (FilterPattern filterPattern : inputmap.keySet()) {
            JSONArray ret = new JSONArray();
            Map<String, Map<String, Set<String>>> filterRules = inputmap.get((Object)filterPattern);
            for (String db_tb : filterRules.keySet()) {
                String[] db_tb_ary = db_tb.split("\\|");
                Map<String, Set<String>> map = filterRules.get(db_tb);
                for (String field : map.keySet()) {
                    Set<String> ruleSet = map.get(field);
                    if (!CollectionUtils.isNotEmpty(ruleSet)) continue;
                    String[] ruleAry = ruleSet.toArray(new String[ruleSet.size()]);
                    for (int i = 0; i < ruleAry.length; ++i) {
                        JSONObject tempjson = new JSONObject();
                        tempjson.put("db", (Object)db_tb_ary[0]);
                        tempjson.put("tb", (Object)db_tb_ary[1]);
                        tempjson.put("drds", (Object)db_tb_ary[2]);
                        tempjson.put("field", (Object)field);
                        tempjson.put("index", (Object)i);
                        tempjson.put("rule", (Object)filterPattern.name());
                        tempjson.put("ruleValue", (Object)ruleAry[i]);
                        ret.add((Object)tempjson);
                    }
                }
            }
            retall.addAll((Collection)ret);
        }
        return retall;
    }

    public static String toString(JSONArray ruleJsonAry) {
        TreeSet<RuleFilter> tempset = new TreeSet<RuleFilter>();
        for (int i = 0; i < ruleJsonAry.size(); ++i) {
            JSONObject jsonObject = ruleJsonAry.getJSONObject(i);
            RuleFilter temppo = new RuleFilter();
            FilterPattern filterPattern = FilterPattern.valueOf(jsonObject.getString("rule"));
            temppo.setFilterPattern(filterPattern);
            if (!filterPattern.isHasColName()) {
                temppo.setField("_");
            } else {
                temppo.setField(jsonObject.getString("field"));
            }
            temppo.setIndex(jsonObject.getIntValue("index"));
            temppo.setRuleValue(jsonObject.getString("ruleValue"));
            tempset.add(temppo);
        }
        return ruleJsonAry.toJSONString();
    }

    static {
        log = LoggerFactory.getLogger(FilterPattern.class);
    }
}

