package net.wicp.tams.common.binlog.alone.binlog.listener;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.constant.JvmStatus;

@Slf4j
public abstract class AbsConsumerListener implements IConsumerListener {
	@Override
	public final void doBui(Rule rule, DuckulaEvent duckulaEvent, boolean isSplit) {
		while (true) {
			try {
				doBusiTrue(rule, duckulaEvent, isSplit);
				break;
			} catch (Throwable e) {
				boolean reDoWait = TimeAssist.reDoWait("common-binlog-alone_Listener", 5);
				if (reDoWait) {
					log.error("发送失败，已达5次上限，退出虚拟机", e);
					LoggerUtil.exit(JvmStatus.s15);
				} else {
					log.error("发送失败，重试", e);
				}
			}
		}
	}

	public abstract void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent, boolean isSplit);

	@Override
	public void close() {
	}
}
