package net.wicp.tams.common.binlog.alone;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.tuple.Triple;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.constant.DateFormatCase;

@Slf4j
public class PluginAssit {
	// 工具用方法
	public static ColHis convertCosHis(String host, String db, String tb, long time,
			List<Triple<String, String, String>> colList) {
		net.wicp.tams.common.binlog.alone.ListenerConf.ColHis.Builder ColHisBuilder = ColHis.newBuilder();
		ColHisBuilder.setTime(time);
		ColHisBuilder.setTimeStr(DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc()
				.format(time == -1 ? System.currentTimeMillis() : time * 1000));
		ColHisBuilder.setServerIp(host);
		ColHisBuilder.setDb(db);
		ColHisBuilder.setTb(tb);
		List<String> namelist = new ArrayList<String>();
		List<String> datatypelist = new ArrayList<String>();
		List<String> coltypelist = new ArrayList<String>();
		for (int i = 0; i < colList.size(); i++) {
			Triple<String, String, String> ele = colList.get(i);
			namelist.add(ele.getLeft());
			datatypelist.add(ele.getMiddle());
			coltypelist.add(ele.getRight());
		}
		ColHisBuilder.addAllCols(namelist);
		ColHisBuilder.addAllColTypes(datatypelist);
		ColHisBuilder.addAllColTypes2(coltypelist);
		ColHis retobj = ColHisBuilder.build();
		return retobj;
	}

	public static String toJsonStr(final Message message) {
		String json = new JsonFormat().printToString(message);
		return json;
	}

	/***
	 * 把jsonl转为message
	 * 
	 * @param jsonstr
	 * @param clazz
	 * @return
	 */
	public static <T extends Message> T toMessage(String jsonstr, Class<T> clazz) {
		if (StringUtil.isNull(jsonstr) || clazz == null) {
			return null;
		}
		if (jsonstr.startsWith("\"")) {
			jsonstr = jsonstr.substring(1);
		}
		if (jsonstr.endsWith("\"")) {
			jsonstr = jsonstr.substring(0, jsonstr.length() - 1);
		}
		jsonstr = jsonstr.replace("\\\"", "\"");
		try {
			Message.Builder builder = (Message.Builder) ReflectAssist.invokeStaticMothed(clazz.getName(), "newBuilder");
			new JsonFormat().merge(jsonstr, ExtensionRegistry.newInstance(), builder);
			return (T) builder.build();
		} catch (Exception e) {
			log.error("转换异常", e);
			return null;
		}
	}

	/*
	 * public static Connection getMainConn(ConnConf.Builder connConf, String
	 * defaultdb) { String url = null; if (StringUtil.isNotNull(defaultdb)) { url =
	 * String.format(
	 * "jdbc:mysql://%s:%s/%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8",
	 * connConf.getHost(), connConf.getPort(), defaultdb); } else { url =
	 * String.format(
	 * "jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8",
	 * connConf.getHost(), connConf.getPort()); } java.sql.Connection conn =
	 * JdbcConnection.getConnection("com.mysql.jdbc.Driver", url,
	 * connConf.getUsername(), connConf.getPassword()); return conn; }
	 */
}
