package net.wicp.tams.common.binlog.alone.filter.impl;

import org.apache.commons.lang3.ArrayUtils;

import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent.Builder;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleFilter;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.filter.IFilter;

/***
 * 操作类型过滤：insert/update/delete
 * 
 * @author Andy
 *
 */
public class FilterForOpttype implements IFilter {

	@Override
	public void doFilter(Builder data, Rule rule, RuleFilter filterRulePo) {
		String[] filterTypes = filterRulePo.getRuleValue().split(",");
		for (int i = data.getItemsCount() - 1; i >= 0; i--) {
			if (!ArrayUtils.contains(filterTypes, data.getOptType().name())) {
				data.removeItems(i);
			}
		}
	}

	@Override
	public void doFilter(DumpEvent data, Rule rule, RuleFilter filterRulePo) {
		// 不支持此类型过滤
		return;
	}
}
