/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.binlog.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.constant.StrPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleManager {
    private static final Logger log = LoggerFactory.getLogger(RuleManager.class);
    private final List<Rule> rules;

    public RuleManager(String rulesstr) {
        this.rules = this.buildRules(rulesstr);
    }

    private List<Rule> buildRules(String rules) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (StringUtil.isNull((Object)rules)) {
            return ruleList;
        }
        String[] ruleAry = rules.split("&");
        for (int i = 0; i < ruleAry.length; ++i) {
            String[] ruleValues = ruleAry[i].split("`");
            if (ruleValues.length == 0 || ruleValues.length != 3 && ruleValues.length != 4) {
                throw new IllegalArgumentException("\u89c4\u5219\u957f\u5ea6\u53ea\u80fd\u4e3a3\u62164!");
            }
            Rule rule = new Rule();
            String itemStr = ruleValues[2];
            boolean isdrds = false;
            if (ruleValues.length > 3) {
                rule.setDrds(ruleValues[2]);
                itemStr = ruleValues[3];
                isdrds = true;
            }
            if (isdrds) {
                rule.setDbPattern(String.format(Rule.drdsTbPatternFormat2, ruleValues[0]));
            } else {
                rule.setDbPattern(this.buildPatter(ruleValues[0]));
            }
            rule.setDbLength(ruleValues[0].length());
            String tbpatternstr = this.buildPatter(ruleValues[1]);
            if (isdrds) {
                if ("dbtb".equals(rule.getDrds())) {
                    tbpatternstr = String.format(Rule.drdsTbPatternFormat2, ruleValues[1]);
                } else if ("db".equals(rule.getDrds())) {
                    tbpatternstr = String.format(Rule.drdsTbPatternFormat1, ruleValues[1]);
                } else if ("no".equals(rule.getDrds())) {
                    tbpatternstr = ruleValues[1];
                }
            }
            rule.setTbPattern(tbpatternstr);
            rule.setTbLength(ruleValues[1].length());
            JSONObject json = JSON.parseObject((String)itemStr);
            for (String key : json.keySet()) {
                RuleItem tempItem = RuleItem.get(key);
                if (tempItem == null) {
                    log.error("\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5key\u4e0e\u53d1\u9001\u8005!");
                    throw new IllegalArgumentException("\u89c4\u5219\u8bbe\u7f6e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5key\u4e0e\u53d1\u9001\u8005!");
                }
                rule.getItems().put(tempItem, json.getString(key));
            }
            ruleList.add(rule);
        }
        return ruleList;
    }

    private String buildPatter(String patter) {
        if (patter.endsWith("_")) {
            return String.format("^%s[0-9]*$", patter);
        }
        return String.format("^%s$", patter);
    }

    public Rule findRule(String db, String tb) {
        if (db.equals(Conf.get((String)"common.binlog.alone.binlog.global.chk.mysql.defaultdb"))) {
            return null;
        }
        for (Rule rule : this.getRules()) {
            boolean rettb;
            boolean retdb;
            if (!"^*$".equals(rule.getDbPattern()) && !(retdb = StrPattern.checkStrFormat((String)rule.getDbPattern(), (String)db)) || !"^*$".equals(rule.getTbPattern()) && !(rettb = StrPattern.checkStrFormat((String)rule.getTbPattern(), (String)tb))) continue;
            return rule;
        }
        return null;
    }

    public boolean isValid(String db, String tb) {
        return this.findRule(db, tb) != null;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleManager)) {
            return false;
        }
        RuleManager other = (RuleManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public String toString() {
        return "RuleManager(rules=" + this.getRules() + ")";
    }
}

