/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone.binlog.bean;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.constant.StrPattern;

public class Rule {
    private String dbPattern;
    private String tbPattern;
    private String drds;
    Map<RuleItem, String> items = new HashMap<RuleItem, String>();
    public static String drdsTbPatternFormat1 = "^%s_[0-9a-zA-Z]{4}";
    public static String drdsTbPatternFormat2 = "^%s_[0-9a-zA-Z]{4}_[0-9]{2,}$";
    private int dbLength;
    private int tbLength;
    private String tbOri;
    private String dbOri;

    public String index(String db, String tb) {
        int i;
        String[] dbPatternAry = this.dbPattern.split("\\|");
        String[] tbPatternAry = this.tbPattern.split("\\|");
        int dbindex = -1;
        int tbindex = -1;
        for (i = 0; i < dbPatternAry.length; ++i) {
            if (!StrPattern.checkStrFormat((String)dbPatternAry[i], (String)db)) continue;
            dbindex = i;
            break;
        }
        for (i = 0; i < tbPatternAry.length; ++i) {
            if (!StrPattern.checkStrFormat((String)tbPatternAry[i], (String)tb)) continue;
            tbindex = i;
            break;
        }
        return String.format("%s|%s", dbindex, tbindex);
    }

    public boolean checkSamePattern(List<String> hasPattern, String db, String tb) {
        String indexstr = this.index(db, tb);
        if (hasPattern.contains(indexstr)) {
            return true;
        }
        hasPattern.add(indexstr);
        return false;
    }

    public JSONObject buildRuleItem() {
        JSONObject retobj = new JSONObject();
        for (RuleItem ruleItem : this.items.keySet()) {
            retobj.put(ruleItem.name(), (Object)this.items.get((Object)ruleItem));
        }
        return retobj;
    }

    private String buildOriRuleStr(String ruleStr) {
        String retStr = ruleStr.replaceAll("\\^", "").replaceAll("\\$", "").replaceAll("\\[0-9\\]\\*", "").replaceAll("_\\[0-9a-zA-Z\\]\\{4\\}", "").replaceAll("_\\[0-9\\]\\{2,\\}", "");
        return retStr;
    }

    public String getTbOri() {
        if (this.tbOri == null) {
            this.tbOri = this.buildOriRuleStr(this.tbPattern);
        }
        return this.tbOri;
    }

    public String getDbOri() {
        if (this.dbOri == null) {
            this.dbOri = this.buildOriRuleStr(this.dbPattern);
        }
        return this.dbOri;
    }

    public boolean equals(Object obj) {
        Rule temp = (Rule)obj;
        return this.dbPattern.equals(temp.getDbPattern()) && this.tbPattern.equals(temp.getTbPattern());
    }

    public int hashCode() {
        return this.dbPattern.hashCode() * 37 + this.tbPattern.hashCode();
    }

    public String getDbPattern() {
        return this.dbPattern;
    }

    public String getTbPattern() {
        return this.tbPattern;
    }

    public String getDrds() {
        return this.drds;
    }

    public Map<RuleItem, String> getItems() {
        return this.items;
    }

    public int getDbLength() {
        return this.dbLength;
    }

    public int getTbLength() {
        return this.tbLength;
    }

    public void setDbPattern(String dbPattern) {
        this.dbPattern = dbPattern;
    }

    public void setTbPattern(String tbPattern) {
        this.tbPattern = tbPattern;
    }

    public void setDrds(String drds) {
        this.drds = drds;
    }

    public void setItems(Map<RuleItem, String> items) {
        this.items = items;
    }

    public void setDbLength(int dbLength) {
        this.dbLength = dbLength;
    }

    public void setTbLength(int tbLength) {
        this.tbLength = tbLength;
    }

    public void setTbOri(String tbOri) {
        this.tbOri = tbOri;
    }

    public void setDbOri(String dbOri) {
        this.dbOri = dbOri;
    }

    public String toString() {
        return "Rule(dbPattern=" + this.getDbPattern() + ", tbPattern=" + this.getTbPattern() + ", drds=" + this.getDrds() + ", items=" + this.getItems() + ", dbLength=" + this.getDbLength() + ", tbLength=" + this.getTbLength() + ", tbOri=" + this.getTbOri() + ", dbOri=" + this.getDbOri() + ")";
    }
}

