/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.binlog.alone;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import org.apache.commons.codec.binary.Base64;

public abstract class DuckulaAssit {
    public static SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static ListenerConf.DuckulaEvent parse(byte[] data) throws InvalidProtocolBufferException {
        ListenerConf.DuckulaEvent retobj = ListenerConf.DuckulaEvent.parseFrom(data);
        return retobj;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static <T extends Serializable> T getKey(ListenerConf.DuckulaEvent.Builder duckulaEventBuilder, int index) {
        Map<String, String> datamap = duckulaEventBuilder.getOptType() == ListenerConf.OptType.delete ? duckulaEventBuilder.getItems(index).getBeforeMap() : duckulaEventBuilder.getItems(index).getAfterMap();
        String value = datamap.get(duckulaEventBuilder.getCols(0));
        ListenerConf.ColumnType columnType = duckulaEventBuilder.getColsType(0);
        Object retobj = value;
        switch (columnType) {
            case LONGLONG: {
                retobj = Long.valueOf(value);
                break;
            }
            case BIT: 
            case TINY: 
            case SHORT: 
            case INT24: 
            case LONG: 
            case ENUM: 
            case SET: {
                retobj = Integer.valueOf(value);
                break;
            }
        }
        return (T)retobj;
    }

    public static ListenerConf.DuckulaEvent.Builder buildSinglItemDuckulaEvent(ListenerConf.DuckulaEvent.Builder duckulaEventBuilder, int index) {
        ListenerConf.DuckulaEvent.Builder duckulaEventbuilder = duckulaEventBuilder.clone();
        ListenerConf.DuckulaEventItem curItems = duckulaEventbuilder.getItems(index);
        duckulaEventbuilder.clearItems();
        duckulaEventbuilder.addItems(curItems);
        return duckulaEventbuilder;
    }

    public static <T extends Serializable> T getValueAfter(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName) {
        return DuckulaAssit.getValue(duckulaEvent, colName, index, true);
    }

    public static <T extends Serializable> T getValueBefore(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName) {
        return DuckulaAssit.getValue(duckulaEvent, colName, index, false);
    }

    public static <T extends Serializable> T getValue(ListenerConf.DuckulaEvent duckulaEvent, String colName, int index) {
        return DuckulaAssit.getValue(duckulaEvent, colName, index, duckulaEvent.getOptType() != ListenerConf.OptType.delete);
    }

    public static <T extends Serializable> T getValue(ListenerConf.DuckulaEvent duckulaEvent, String colName, int index, boolean isAfter) {
        if (duckulaEvent.getColsCount() != duckulaEvent.getColsList().size()) {
            throw new RuntimeException("\u5217\u540d\u4e0e\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u3002");
        }
        String value = DuckulaAssit.getValueStr(duckulaEvent, index, colName, isAfter);
        if (DuckulaAssit.isEmpty(value)) {
            return null;
        }
        int colindex = duckulaEvent.getColsList().indexOf((Object)colName);
        ListenerConf.ColumnType columnType = duckulaEvent.getColsType(colindex);
        Object retobj = null;
        switch (columnType) {
            case LONGLONG: {
                retobj = Long.valueOf(value);
                break;
            }
            case BIT: 
            case TINY: 
            case SHORT: 
            case INT24: 
            case LONG: 
            case ENUM: 
            case SET: {
                retobj = Integer.valueOf(value);
                break;
            }
            case FLOAT: {
                retobj = Float.valueOf(value);
                break;
            }
            case DOUBLE: {
                retobj = Double.valueOf(value);
                break;
            }
            case DECIMAL: 
            case NEWDECIMAL: {
                retobj = new BigDecimal(value);
                break;
            }
            case BLOB: 
            case GEOMETRY: {
                try {
                    retobj = Base64.decodeBase64((String)value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case YEAR: {
                try {
                    retobj = Integer.valueOf(value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case TIMESTAMP2: 
            case DATETIME2: {
                try {
                    retobj = formater.parse(value);
                }
                catch (ParseException e) {
                    retobj = value;
                }
                break;
            }
            default: {
                retobj = value;
            }
        }
        return (T)retobj;
    }

    public static String getValueStr(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName) {
        return DuckulaAssit.getValueStr(duckulaEvent, index, colName, duckulaEvent.getOptType() != ListenerConf.OptType.delete);
    }

    public static String getValueStr(ListenerConf.DuckulaEvent duckulaEvent, int index, String colName, boolean isAfter) {
        ListenerConf.DuckulaEventItem item = duckulaEvent.getItems(index);
        String value = isAfter ? item.getAfterMap().get(colName) : item.getBeforeMap().get(colName);
        return value;
    }

    public static Map<String, String> getValueMap(ListenerConf.DuckulaEvent duckulaEvent, int index) {
        ListenerConf.DuckulaEventItem item = duckulaEvent.getItems(index);
        Map<String, String> retMap = duckulaEvent.getOptType() != ListenerConf.OptType.delete ? item.getAfterMap() : item.getBeforeMap();
        return retMap;
    }

    public static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static JSONObject convertJson(ListenerConf.DuckulaEvent duckulaEvent) {
        JSONObject retobj = new JSONObject();
        retobj.put("optType", (Object)duckulaEvent.getOptType());
        JSONArray items = new JSONArray();
        for (ListenerConf.DuckulaEventItem duckulaEventItem : duckulaEvent.getItemsList()) {
            JSONObject itemobj = new JSONObject();
            switch (duckulaEvent.getOptType()) {
                case update: {
                    itemobj.put("after", duckulaEventItem.getAfterMap());
                    itemobj.put("before", duckulaEventItem.getBeforeMap());
                    break;
                }
                case insert: {
                    itemobj.put("after", duckulaEventItem.getAfterMap());
                    break;
                }
                case delete: {
                    itemobj.put("before", duckulaEventItem.getBeforeMap());
                    break;
                }
            }
            items.add((Object)itemobj);
        }
        retobj.put("items", (Object)items);
        return retobj;
    }

    public static JSONObject convertJson(DumpEvent dumpEvent) {
        JSONObject retobj = new JSONObject();
        retobj.put("optType", (Object)"select");
        JSONArray items = new JSONArray();
        for (Map<String, String> data : dumpEvent.getDatas()) {
            JSONObject itemobj = new JSONObject();
            itemobj.put("after", data);
            items.add((Object)itemobj);
        }
        retobj.put("items", (Object)items);
        return retobj;
    }
}

