package net.wicp.tams.common.binlog.alone.binlog.listener;

import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.PushlishBean;
import net.wicp.tams.common.exception.ProjectException;

public abstract class AbsBusi {

	protected final AbsBusi busi;
	protected final ConnConf connConf;

	public AbsBusi(AbsBusi busi, ConnConf connConf) {
		this.busi = busi;
		this.connConf = connConf;
	}

	// 先做别人，再做自己的事情
	public final void doWith(PushlishBean pushlishBean) throws ProjectException {
		if (this.busi != null) {
			this.busi.doWith(pushlishBean);
		}
		doSelf(pushlishBean);
	}

	protected abstract void doSelf(PushlishBean pushlishBean);

}
