package net.wicp.tams.common.binlog.alone.binlog.listener;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Triple;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.apiext.jdbc.JdbcConnection;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.ConnConf;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

@Slf4j
public abstract class AbsBinlogListener implements IBinlogListener {
	// 必须要有index值
	protected RuleManager ruleManager;

	protected ConnConf connConf;

	@Override
	public final void init(ConnConf connConf) {
		this.ruleManager = new RuleManager(connConf.getRule());
		this.connConf = connConf;
		int i = 0;
		// 排队common-jdbc，因为会影响control模块
		String dburl = String.format(
				"jdbc:mysql://%s:%s?useUnicode=true&characterEncoding=UTF-8&autoReconnect=true&failOverReadOnly=false",
				connConf.getHost(), connConf.getPort());
		Connection mainConn = JdbcConnection.getConnectionMyql(dburl, connConf.getUsername(), connConf.getPassword());// DruidAssit.getConnection(connConf.getConfName());
		for (Rule rule : ruleManager.getRules()) {
			doInit(rule, i++);// 先执行子类的初始化工作，创建Esclient会要它先执行。autocreate工作
			// 再用常用的检查
			List<String[]> allTables = MySqlAssit.getAllTables(mainConn, rule.getDbPattern(), rule.getTbPattern());
			if (CollectionUtils.isNotEmpty(allTables)) {
				List<String> hasPattern = new ArrayList<String>();
				for (String[] dbtb : allTables) {
					if (rule.checkSamePattern(hasPattern, dbtb[0], dbtb[1])) {// 已处理过就不处理了，处理“|”的情况
						continue;
					}
					List<Triple<String, String, String>> colList = MySqlAssit.getColsNew(mainConn, dbtb[0], dbtb[1],
							connConf.getRds() ? YesOrNo.yes : YesOrNo.no);
					ColHis convertCosHis = PluginAssit.convertCosHis(connConf.getHost(), dbtb[0], dbtb[1], -1l,
							colList);
					try {
						Result doAlterTableCallBack = doAlterTableCallBack(rule, convertCosHis, null);// 没办法恢复当时的SQL，只能传
																										// null.
						if (doAlterTableCallBack != null && !doAlterTableCallBack.isSuc()) {
							throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail,
									"初始化时，检查同步失败:" + doAlterTableCallBack.getMessage());
						}
					} catch (Exception e) {
						log.error("初始化时，检查同步失败", e);
					}
				}
			}
		}
		try {
			mainConn.close();
		} catch (SQLException e) {
		}
	}

	@Override
	public void close() {
	}

	@Override
	public final void doBui(Rule rule, DuckulaEvent duckulaEvent) {
		while (true) {
			try {
				doBusiTrue(rule, duckulaEvent);
				break;
			} catch (Throwable e) {
				boolean reDoWait = TimeAssist.reDoWait("common-binlog-alone_Listener", 5);
				if (reDoWait) {
					log.error("发送失败，已达5次上限，退出虚拟机", e);
					LoggerUtil.exit(JvmStatus.s15);
				} else {
					log.error("发送失败，重试", e);
				}
			}
		}
	}

	public abstract void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent);

	public abstract void doInit(Rule rule, int index);

}
