package net.wicp.tams.common.binlog.alone.binlog.bean;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.StrPattern;

@Data
@Slf4j
public class RuleManager {

	private final List<Rule> rules;

	public RuleManager(String rulesstr) {
		this.rules = buildRules(rulesstr);
	}

	private List<Rule> buildRules(String rules) {
		List<Rule> ruleList = new ArrayList<>();
		if (StringUtil.isNull(rules)) {
			return ruleList;
		}
		String[] ruleAry = rules.split("&");
		for (int i = 0; i < ruleAry.length; i++) {
			String[] ruleValues = ruleAry[i].split("`");
			if (ruleValues.length == 0 || (ruleValues.length != 3 && ruleValues.length != 4)) {
				throw new IllegalArgumentException("规则长度只能为3或4!");
			}
			Rule rule = new Rule();

			String itemStr = ruleValues[2];
			boolean isdrds = false;
			if (ruleValues.length > 3) {
				rule.setDrds(ruleValues[2]);
				itemStr = ruleValues[3];
				isdrds = true;
			}
			if (isdrds) {
				rule.setDbPattern(String.format(Rule.drdsTbPatternFormat2, ruleValues[0]));// drds支持
			} else {
				rule.setDbPattern(buildPatter(ruleValues[0]));
			}
			rule.setDbLength(ruleValues[0].length());

			String tbpatternstr = buildPatter(ruleValues[1]);
			if (isdrds) {
				if ("dbtb".equals(rule.getDrds())) {
					tbpatternstr = String.format(Rule.drdsTbPatternFormat2, ruleValues[1]);// drds支持
				} else if ("db".equals(rule.getDrds())) {
					tbpatternstr = String.format(Rule.drdsTbPatternFormat1, ruleValues[1]);// drds支持
				} else if ("no".equals(rule.getDrds())) {
					tbpatternstr = ruleValues[1];
				}
			}
			rule.setTbPattern(tbpatternstr);
			rule.setTbLength(ruleValues[1].length());

			JSONObject json = JSON.parseObject(itemStr);
			for (String key : json.keySet()) {
				RuleItem tempItem = RuleItem.get(key);
				if (tempItem == null) {
					log.error("规则设置出错，请检查key与发送者!");
					throw new IllegalArgumentException("规则设置出错，请检查key与发送者!");
				} else {
					rule.getItems().put(tempItem, json.getString(key));
				}
			}
			ruleList.add(rule);
		}
		return ruleList;
	}

	private String buildPatter(String patter) {
		if (patter.endsWith("_")) {
			return String.format("^%s[0-9]*$", patter);
		} else {
			return String.format("^%s$", patter);
		}
	}

	/***
	 * 找到表的匹配规则
	 *
	 * @param db
	 * @param tb
	 * @return
	 */
	public Rule findRule(String db, String tb) {
		if (db.equals(Conf.get("common.binlog.alone.binlog.global.chk.mysql.defaultdb"))) {// 去除mysql数据库"^.*$".equals(connConf.getDbPattern())，它会存在
			// ha_health_check 心跳表
			return null;
		}
		for (Rule rule : this.getRules()) {
			if (!"^*$".equals(rule.getDbPattern())) {
				boolean retdb = StrPattern.checkStrFormat(rule.getDbPattern(), db);
				if (!retdb) {
					continue;
				}
			}
			if (!"^*$".equals(rule.getTbPattern())) {
				boolean rettb = StrPattern.checkStrFormat(rule.getTbPattern(), tb);
				if (!rettb) {
					continue;
				}
			}
			return rule;
		}
		return null;
	}

	public boolean isValid(String db, String tb) {
		return findRule(db, tb) != null;
	}
}
