package net.wicp.tams.common.binlog.alone.binlog.bean;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import lombok.Data;
import net.wicp.tams.common.constant.StrPattern;

@Data
public class Rule {
	private String dbPattern;
	private String tbPattern;
	private String drds;// dbtb 分库也分表 db 只分库 no 不分库分表
	// private String splitKey;//
	// private String remark;
	Map<RuleItem, String> items = new HashMap<>();

	public static String drdsTbPatternFormat1 = "^%s_[0-9a-zA-Z]{4}";

	public static String drdsTbPatternFormat2 = "^%s_[0-9a-zA-Z]{4}_[0-9]{2,}$";

	private int dbLength;

	private int tbLength;

	private String tbOri;

	private String dbOri;

	public String index(String db, String tb) {// TODO
		String[] dbPatternAry = dbPattern.split("\\|");
		String[] tbPatternAry = tbPattern.split("\\|");
		int dbindex = -1, tbindex = -1;
		for (int i = 0; i < dbPatternAry.length; i++) {
			if (StrPattern.checkStrFormat(dbPatternAry[i], db)) {
				dbindex = i;
				break;
			}
		}
		for (int i = 0; i < tbPatternAry.length; i++) {
			if (StrPattern.checkStrFormat(tbPatternAry[i], tb)) {
				tbindex = i;
				break;
			}
		}
		return String.format("%s|%s", dbindex, tbindex);
	}

	/***
	 * 检查是否已处理的模式
	 * 
	 * @param hasPattern
	 * @param db
	 * @param tb
	 * @return
	 */
	public boolean checkSamePattern(List<String> hasPattern, String db, String tb) {
		String indexstr = index(db, tb);
		if (hasPattern.contains(indexstr)) {
			return true;
		} else {
			hasPattern.add(indexstr);
			return false;
		}
	}

	public JSONObject buildRuleItem() {
		JSONObject retobj = new JSONObject();
		for (RuleItem ruleItem : items.keySet()) {
			retobj.put(ruleItem.name(), items.get(ruleItem));
		}
		return retobj;
	}

	private String buildOriRuleStr(String ruleStr) {
		String retStr = ruleStr.replaceAll("\\^", "").replaceAll("\\$", "").replaceAll("\\[0-9\\]\\*", "")
				.replaceAll("_\\[0-9a-zA-Z\\]\\{4\\}", "").replaceAll("_\\[0-9\\]\\{2,\\}", "");
		return retStr;
	}

	public String getTbOri() {
		if (tbOri == null) {
			this.tbOri = buildOriRuleStr(tbPattern);
		}
		return this.tbOri;
	}

	public String getDbOri() {
		if (dbOri == null) {
			this.dbOri = buildOriRuleStr(dbPattern);
		}
		return this.dbOri;
	}

	@Override
	public boolean equals(Object obj) {
		Rule temp = (Rule) obj;
		return this.dbPattern.equals(temp.getDbPattern()) && this.tbPattern.equals(temp.getTbPattern());
	}

	@Override
	public int hashCode() {
		return this.dbPattern.hashCode() * 37 + this.tbPattern.hashCode();
	}
}
