package net.wicp.tams.common.binlog.alone;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;

import org.apache.commons.codec.binary.Base64;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.InvalidProtocolBufferException;

import net.wicp.tams.common.binlog.alone.ListenerConf.ColumnType;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEventItem;
import net.wicp.tams.common.binlog.alone.ListenerConf.OptType;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;

public abstract class DuckulaAssit {
	public static SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	public static DuckulaEvent parse(byte[] data) throws InvalidProtocolBufferException {
		DuckulaEvent retobj = DuckulaEvent.parseFrom(data);
		return retobj;
	}

	public static boolean isEmpty(CharSequence cs) {
		return cs == null || cs.length() == 0;
	}

	public static <T extends Serializable> T getKey(DuckulaEvent.Builder duckulaEventBuilder, int index) {
		Map<String, String> datamap = duckulaEventBuilder.getOptType() == OptType.delete
				? duckulaEventBuilder.getItems(index).getBeforeMap()
				: duckulaEventBuilder.getItems(index).getAfterMap();
		String value = datamap.get(duckulaEventBuilder.getCols(0));
		ColumnType columnType = duckulaEventBuilder.getColsType(0);
		Serializable retobj = value;
		switch (columnType) {
		case LONGLONG:
			retobj = Long.valueOf(value);
			break;
		case BIT:
		case TINY:
		case SHORT:
		case INT24:
		case LONG:
		case ENUM:
		case SET:
			retobj = Integer.valueOf(value);
			break;
		default:
			break;
		}
		return (T) retobj;
	}

	/***
	 * 创建只有一个item的DuckulaEvent
	 * 
	 * @param duckulaEventBuilder
	 * @param index
	 * @return
	 */
	public static DuckulaEvent.Builder buildSinglItemDuckulaEvent(DuckulaEvent.Builder duckulaEventBuilder, int index) {
		net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent.Builder duckulaEventbuilder = duckulaEventBuilder
				.clone();
		DuckulaEventItem curItems = duckulaEventbuilder.getItems(index);
		duckulaEventbuilder.clearItems();
		duckulaEventbuilder.addItems(curItems);
		return duckulaEventbuilder;
	}

	/***
	 * 得到变化后数据的值
	 * 
	 * @param duckulaEvent
	 * @param colName
	 * @return
	 */
	public static <T extends Serializable> T getValueAfter(DuckulaEvent duckulaEvent, int index, String colName) {
		return getValue(duckulaEvent, colName, index, true);
	}

	public static <T extends Serializable> T getValueBefore(DuckulaEvent duckulaEvent, int index, String colName) {
		return getValue(duckulaEvent, colName, index, false);
	}

	public static <T extends Serializable> T getValue(DuckulaEvent duckulaEvent, String colName, int index) {
		return getValue(duckulaEvent, colName, index, duckulaEvent.getOptType() != OptType.delete);
	}

	@SuppressWarnings("unchecked")
	public static <T extends Serializable> T getValue(DuckulaEvent duckulaEvent, String colName, int index,
			boolean isAfter) {
		if (duckulaEvent.getColsCount() != duckulaEvent.getColsList().size()) {
			throw new RuntimeException("列名与值不一致，请联系相关人员。");
		}
		String value = getValueStr(duckulaEvent, index, colName, isAfter);
		if (isEmpty(value)) {
			return null;
		}
		int colindex = duckulaEvent.getColsList().indexOf(colName);
		ColumnType columnType = duckulaEvent.getColsType(colindex);
		Serializable retobj = null;
		switch (columnType) {
		case LONGLONG:
			retobj = Long.valueOf(value);
			break;
		case BIT:
		case TINY:
		case SHORT:
		case INT24:
		case LONG:
		case ENUM:
		case SET:
			retobj = Integer.valueOf(value);
			break;
		case FLOAT:
			retobj = Float.valueOf(value);
			break;

		case DOUBLE:
			retobj = Double.valueOf(value);
			break;
		case DECIMAL:
		case NEWDECIMAL:
			retobj = new BigDecimal(value);
			break;
		case BLOB:
		case GEOMETRY:
			try {
				retobj = Base64.decodeBase64(value);
			} catch (Exception e) {
				retobj = value;
			}
			break;
		case YEAR:
			try {
				retobj = Integer.valueOf(value);
			} catch (Exception e) {
				retobj = value;
			}
			break;
		case TIMESTAMP2:
		case DATETIME2:
			try {
				retobj = formater.parse(value);
			} catch (ParseException e) {
				retobj = value;
			}
			break;

		default:
			retobj = value;
			break;
		}
		return (T) retobj;
	}

	public static String getValueStr(DuckulaEvent duckulaEvent, int index, String colName) {
		return getValueStr(duckulaEvent, index, colName, duckulaEvent.getOptType() != OptType.delete);
	}

	public static String getValueStr(DuckulaEvent duckulaEvent, int index, String colName, boolean isAfter) {
		DuckulaEventItem item = duckulaEvent.getItems(index);
		String value;
		if (isAfter) {
			value = item.getAfterMap().get(colName);
		} else {
			value = item.getBeforeMap().get(colName);
		}
		return value;
	}

	public static Map<String, String> getValueMap(DuckulaEvent duckulaEvent, int index) {
		DuckulaEventItem item = duckulaEvent.getItems(index);
		Map<String, String> retMap;
		if (duckulaEvent.getOptType() != OptType.delete) {
			retMap = item.getAfterMap();
		} else {
			retMap = item.getBeforeMap();
		}
		return retMap;
	}

	public static byte[] getBytes(String filePath) {
		byte[] buffer = null;
		try {
			File file = new File(filePath);
			FileInputStream fis = new FileInputStream(file);
			ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
			byte[] b = new byte[1000];
			int n;
			while ((n = fis.read(b)) != -1) {
				bos.write(b, 0, n);
			}
			fis.close();
			bos.close();
			buffer = bos.toByteArray();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return buffer;
	}

	public static JSONObject convertJson(DuckulaEvent duckulaEvent) {
		JSONObject retobj = new JSONObject();
		retobj.put("optType", duckulaEvent.getOptType());
		JSONArray items = new JSONArray();
		for (DuckulaEventItem duckulaEventItem : duckulaEvent.getItemsList()) {
			JSONObject itemobj = new JSONObject();
			switch (duckulaEvent.getOptType()) {
			case update:
				itemobj.put("after", duckulaEventItem.getAfterMap());
				itemobj.put("before", duckulaEventItem.getBeforeMap());
				break;
			case insert:
				itemobj.put("after", duckulaEventItem.getAfterMap());
				break;
			case delete:
				itemobj.put("before", duckulaEventItem.getBeforeMap());
				break;
			default:
				break;
			}
			items.add(itemobj);
		}
		retobj.put("items", items);
		return retobj;
	}

	public static JSONObject convertJson(DumpEvent dumpEvent) {
		JSONObject retobj = new JSONObject();
		retobj.put("optType", "select");
		JSONArray items = new JSONArray();
		for (Map<String, String> data : dumpEvent.getDatas()) {
			JSONObject itemobj = new JSONObject();
			itemobj.put("after", data);
			items.add(itemobj);
		}
		retobj.put("items", items);
		return retobj;
	}

}
