/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.aws.sqs.listener;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.aws.SqsData;
import net.wicp.tams.common.aws.sqs.SqsService;
import net.wicp.tams.common.aws.sqs.bean.MessageCommon;
import net.wicp.tams.common.aws.sqs.threadlocal.SqsClientThreadlocal;
import net.wicp.tams.common.aws.sqs.threadlocal.SqsContext;
import net.wicp.tams.common.thread.ThreadPool;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsSQSListener {
    private static final Logger log = LoggerFactory.getLogger(AbsSQSListener.class);

    public final boolean doListener(MessageCommon msgPag) {
        boolean result = false;
        long waitTime = (System.currentTimeMillis() - msgPag.getReceiveTime()) / 1000L;
        if (waitTime > msgPag.getVisibilityTimeout()) {
            String curNamespace = (String)PerthreadManager.getInstance().createValue((Object)"tams-namespace", String.class).get();
            if (StringUtil.isNull((Object)curNamespace)) {
                log.warn("The thread wait time is greater than the visible time\uff0cthe msgid:{}", (Object)msgPag.getSqsData().getMessageId());
            } else {
                ThreadPoolExecutor cur = (ThreadPoolExecutor)ThreadPool.getExecutorservicemap().get(curNamespace);
                log.warn("The thread wait time is greater than the visible time\uff0cthe msgid:{},namespace:{},activeCount:{},allTaskCount{},coreSize:{},maxSize:{},queueSize{}", new Object[]{msgPag.getSqsData().getMessageId(), curNamespace, cur.getActiveCount(), cur.getTaskCount(), cur.getCorePoolSize(), cur.getMaximumPoolSize(), cur.getQueue().size()});
            }
            return result;
        }
        if (StringUtil.isNotNull((Object)msgPag.getSqsData().getContext())) {
            ObjectNode jsonObject = null;
            try {
                jsonObject = (ObjectNode)JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)msgPag.getSqsData().getContext());
            }
            catch (Throwable e) {
                jsonObject = JsonNodeFactory.instance.objectNode();
                jsonObject.put("context", msgPag.getSqsData().getContext());
            }
            ObjectNode createPerThreadSqsContext = SqsContext.createPerThreadSqsContext();
            Map jsonToMap = JSONUtil.jsonToMap((ObjectNode)jsonObject);
            for (String key : jsonToMap.keySet()) {
                createPerThreadSqsContext.putPOJO(key, (Object)msgPag);
            }
        } else {
            SqsContext.cleanContext();
        }
        SqsService.doWithTime.put(msgPag.getSqsData().getMessageId(), System.currentTimeMillis());
        try {
            result = this.cusListener(msgPag.getSqsData());
        }
        catch (Throwable e) {
            log.error("\u4e1a\u52a1\u6267\u884c\u5931\u8d25,id:" + msgPag.getSqsData().getMessageId(), e);
            result = false;
        }
        SqsService.doWithTime.remove(msgPag.getSqsData().getMessageId());
        try {
            if (result) {
                long doWithTime = (System.currentTimeMillis() - msgPag.getReceiveTime()) / 1000L;
                if (doWithTime > msgPag.getVisibilityTimeout()) {
                    log.warn("The thread wait time is greater than the visible time\uff0cthe msgid:{}", (Object)msgPag.getSqsData().getMessageId());
                }
                SqsService sqsPerThread = SqsClientThreadlocal.createPerThreadSqsClient();
                sqsPerThread.deleteMessage(msgPag.getSqsData());
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6d88\u606f\u65f6\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public abstract boolean cusListener(SqsData var1);
}

