/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.aws.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.AmazonSQSException;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.QueueDoesNotExistException;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.PwdUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.aws.DataType;
import net.wicp.tams.common.aws.SqsData;
import net.wicp.tams.common.aws.common.AwsHelper;
import net.wicp.tams.common.aws.common.CountingOutputStream;
import net.wicp.tams.common.aws.common.TamsCredentialsProvider;
import net.wicp.tams.common.aws.s3.S3Service;
import net.wicp.tams.common.aws.s3.threadlocal.S3ClientThreadlocal;
import net.wicp.tams.common.aws.sqs.bean.MessageCommon;
import net.wicp.tams.common.aws.sqs.bean.QueueAttributes;
import net.wicp.tams.common.aws.sqs.constant.QueryType;
import net.wicp.tams.common.aws.sqs.listener.AbsSQSListener;
import net.wicp.tams.common.aws.sqs.threadlocal.SqsClientThreadlocal;
import net.wicp.tams.common.aws.sqs.threadlocal.SqsContext;
import net.wicp.tams.common.thread.ThreadPool;
import net.wicp.tams.common.thread.threadlocal.PerThreadValue;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsService {
    private static final Logger log = LoggerFactory.getLogger(SqsService.class);
    private final AmazonSQS sqs;
    private static final String VERSION = "v2";
    private static final String VERSIONJAR = "1.2.18";
    private static volatile boolean isInit;
    public static final Map<String, Long> doWithTime;

    public AmazonSQS getSqs() {
        return this.sqs;
    }

    public void close() {
    }

    private SqsService(AmazonSQS sqs) {
        this.sqs = sqs;
        this.init();
    }

    private SqsService() {
        AmazonSQS amazonSQS;
        this.sqs = amazonSQS = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClient.builder().withRegion(Conf.get((String)"common.aws.region"))).withCredentials((AWSCredentialsProvider)new TamsCredentialsProvider())).build();
        this.init();
    }

    public static SqsService getInstThread() {
        SqsService createPerThreadEsClient = SqsClientThreadlocal.createPerThreadSqsClient();
        return createPerThreadEsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (isInit) return;
        Class<SqsService> clazz = SqsService.class;
        synchronized (SqsService.class) {
            if (isInit) return;
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
            service.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Map poolmap = ThreadPool.getExecutorservicemap();
                    for (String key : poolmap.keySet()) {
                        ThreadPoolExecutor cur = (ThreadPoolExecutor)poolmap.get(key);
                        int activeCount = cur.getActiveCount();
                        long taskCount = cur.getTaskCount();
                        log.info("the pool name={} activeCount={} maxCount={} taskCount={}", new Object[]{key, activeCount, cur.getMaximumPoolSize(), taskCount});
                    }
                    int doWithLongNum = 0;
                    for (String msgId : doWithTime.keySet()) {
                        if (System.currentTimeMillis() - doWithTime.get(msgId) <= 30000L) continue;
                        ++doWithLongNum;
                    }
                    log.info("Number of records processed for timeout:{}", (Object)doWithLongNum);
                }
            }, 10L, 30L, TimeUnit.SECONDS);
            log.info("version========={}", (Object)VERSIONJAR);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    log.info("----------------------\u6267\u884c\u5173\u95ed\u8fdb\u7a0b \u94a9\u5b50\u5f00\u59cb-------------------------------------");
                    ThreadPool.shutdown();
                    log.info("----------------------\u6267\u884c\u5173\u95ed\u8fdb\u7a0b \u94a9\u5b50\u5b8c\u6210-------------------------------------");
                }
            });
            isInit = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<MessageCommon> queueReceiver(String queueName) {
        return this.queueReceiver(queueName, Conf.getInt((String)"common.aws.sqs.receiver.maxNumberOfMessages"), Conf.getInt((String)"common.aws.sqs.receiver.waitTimeSeconds"), new String[0]);
    }

    public List<MessageCommon> queueReceiver(String queueName, String ... attributeNames) {
        return this.queueReceiver(queueName, Conf.getInt((String)"common.aws.sqs.receiver.maxNumberOfMessages"), Conf.getInt((String)"common.aws.sqs.receiver.waitTimeSeconds"), attributeNames);
    }

    public List<MessageCommon> queueReceiverAllattr(String queueName) {
        return this.queueReceiver(queueName, Conf.getInt((String)"common.aws.sqs.receiver.maxNumberOfMessages"), Conf.getInt((String)"common.aws.sqs.receiver.waitTimeSeconds"), ".*");
    }

    public void queueReceiverListener(final String queueName, final String namespace, final AbsSQSListener sqsListerer, int maxNumberOfMessages, final int waitTimeSeconds, final String ... attributeNames) {
        Properties props;
        Properties properties = props = "default".equals(namespace) ? Conf.copyProperties() : this.getNoDefaultPoolConf(namespace);
        final int maxNumberOfMessagesTrue = maxNumberOfMessages > 0 ? maxNumberOfMessages : ("default".equals(namespace) ? maxNumberOfMessages : Integer.parseInt(props.getProperty(String.format("common.apiext.thread.pool.%s.maxNumberOfMessages", namespace))));
        log.info("the namespace:{} queueName:{} maxNumberOfMessages:{}", new Object[]{namespace, queueName, maxNumberOfMessagesTrue});
        final ExecutorService threadPool = ThreadPool.getThreadPoolByName((String)namespace, (Properties)props);
        threadPool.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(String.format("Listener---%s", queueName));
                block10: while (true) {
                    List<Object> queueRecievList = null;
                    try {
                        queueRecievList = SqsService.this.queueReceiver(queueName, maxNumberOfMessagesTrue, waitTimeSeconds, attributeNames);
                        TimeAssist.reDoWaitInit((String)"aws-sqs");
                    }
                    catch (QueueDoesNotExistException e) {
                        log.error("\u961f\u5217\uff1a" + queueName + "\u4e0d\u5b58\u5728", (Throwable)e);
                        queueRecievList = new ArrayList();
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (AmazonSQSException e) {
                        log.error("\u6b64\u5e10\u53f7\u6709\u592a\u591a\u7684\u8bf7\u6c42\uff0c\u961f\u5217\uff1a" + queueName, (Throwable)e);
                        queueRecievList = new ArrayList();
                        boolean reDoWait = TimeAssist.reDoWait((String)"aws-sqs", (int)5);
                        if (reDoWait) {
                            try {
                                Thread.sleep(32000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (Throwable e) {
                        log.error("\u62c9\u53d6\u8bb0\u5f55\u65f6\u5931\u8d25", e);
                        queueRecievList = new ArrayList();
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException reDoWait) {
                            // empty catch block
                        }
                    }
                    Iterator<Object> iterator = queueRecievList.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block10;
                        final MessageCommon messageTams = (MessageCommon)iterator.next();
                        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

                            @Override
                            public Boolean call() {
                                PerThreadValue createValue = PerthreadManager.getInstance().createValue((Object)"tams-namespace", String.class);
                                createValue.set((Object)namespace);
                                return sqsListerer.doListener(messageTams);
                            }
                        });
                        threadPool.submit(futureTask);
                    }
                    break;
                }
            }
        });
    }

    private Properties getNoDefaultPoolConf(String namespace) {
        String preStr = "common.apiext.thread.pool." + namespace;
        Properties oriProps = Conf.replacePre((String)"common.aws.sqs.receiver.pool", (String)preStr);
        Map overmap = Conf.getPre((String)preStr, (boolean)false);
        oriProps.putAll((Map<?, ?>)overmap);
        return oriProps;
    }

    public void queueReceiverListener(String queueName, AbsSQSListener sqsListerer, int maxNumberOfMessages, int waitTimeSeconds, int visibilityTimeout, String ... attributeNames) {
        this.queueReceiverListener(queueName, "default", sqsListerer, maxNumberOfMessages, waitTimeSeconds, attributeNames);
    }

    public void queueReceiverListenerVar(String queueNameVar, AbsSQSListener sqsListerer, int maxNumberOfMessages, int waitTimeSeconds, int visibilityTimeout, String ... attributeNames) {
        this.queueReceiverListener(Conf.get((String)queueNameVar), "default", sqsListerer, maxNumberOfMessages, waitTimeSeconds, attributeNames);
    }

    public void queueReceiverListener(String queueName, AbsSQSListener sqsListerer, String ... attributeNames) {
        this.queueReceiverListener(queueName, "default", sqsListerer, 0, 0, attributeNames);
    }

    public void queueReceiverListenerVar(String queueNameVar, AbsSQSListener sqsListerer, String ... attributeNames) {
        this.queueReceiverListener(Conf.get((String)queueNameVar), "default", sqsListerer, 0, 0, attributeNames);
    }

    public void queueReceiverListener(String queueName, String namespace, AbsSQSListener sqsListerer, String ... attributeNames) {
        this.queueReceiverListener(queueName, namespace, sqsListerer, 0, 0, attributeNames);
    }

    public void queueReceiverListenerVar(String queueNameVar, String namespace, AbsSQSListener sqsListerer, String ... attributeNames) {
        this.queueReceiverListener(Conf.get((String)queueNameVar), namespace, sqsListerer, 0, 0, attributeNames);
    }

    public ReceiveMessageResult queueReceiverOri(String queueName, int maxNumberOfMessages, int waitTimeSeconds, int visibilityTimeout, String ... attributeNames) {
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest().withQueueUrl(queueName).withWaitTimeSeconds(Integer.valueOf(waitTimeSeconds <= 0 ? Conf.getInt((String)"common.aws.sqs.receiver.waitTimeSeconds") : waitTimeSeconds)).withAttributeNames(new String[]{"SentTimestamp", "ApproximateReceiveCount"}).withMaxNumberOfMessages(Integer.valueOf(maxNumberOfMessages <= 0 ? Conf.getInt((String)"common.aws.sqs.receiver.maxNumberOfMessages") : maxNumberOfMessages));
        if (visibilityTimeout > 0) {
            receiveMessageRequest.withVisibilityTimeout(Integer.valueOf(visibilityTimeout));
        }
        if (ArrayUtils.isNotEmpty((Object[])attributeNames)) {
            receiveMessageRequest.withMessageAttributeNames(attributeNames);
        }
        ReceiveMessageResult result = this.sqs.receiveMessage(receiveMessageRequest);
        return result;
    }

    public List<MessageCommon> queueReceiver(String queueName, int maxNumberOfMessages, int waitTimeSeconds, String ... attributeNames) {
        ReceiveMessageResult result = this.queueReceiverOri(queueName, maxNumberOfMessages, waitTimeSeconds, 0, attributeNames);
        ArrayList<MessageCommon> retlist = new ArrayList<MessageCommon>();
        if (!result.getMessages().isEmpty()) {
            QueueAttributes queueAttributes = this.getQueueAttributes(queueName);
            List messages = result.getMessages();
            for (Message message : messages) {
                MessageCommon messagecommon = new MessageCommon();
                messagecommon.setSuc(false);
                messagecommon.setReceiveTime(System.currentTimeMillis());
                messagecommon.setVisibilityTimeout(queueAttributes.getVisibilityTimeout());
                messagecommon.setMessage(message);
                String body = message.getBody();
                SqsData.Builder sqsDataBuilder = SqsData.newBuilder();
                sqsDataBuilder.setMessageId(message.getMessageId());
                sqsDataBuilder.setQueueNameReceive(queueName);
                sqsDataBuilder.setReceiptHandle(message.getReceiptHandle());
                Map attributes = message.getAttributes();
                if (MapUtils.isNotEmpty((Map)attributes)) {
                    if (attributes.containsKey("SentTimestamp")) {
                        sqsDataBuilder.setSentTimestamp(Long.parseLong((String)attributes.get("SentTimestamp")));
                    }
                    if (attributes.containsKey("ApproximateReceiveCount")) {
                        sqsDataBuilder.setReceiveCount(Integer.parseInt((String)attributes.get("ApproximateReceiveCount")));
                    }
                }
                try {
                    ObjectNode parseObject = (ObjectNode)JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)body);
                    if (parseObject.has("bucketName")) {
                        sqsDataBuilder.setBucketName(parseObject.get("bucketName").asText());
                    }
                    if (parseObject.has("s3key")) {
                        sqsDataBuilder.setS3Key(parseObject.get("s3key").asText());
                    }
                    if (parseObject.has("queueName")) {
                        sqsDataBuilder.setQueueName(parseObject.get("queueName").asText());
                    }
                    if (parseObject.has("msg")) {
                        sqsDataBuilder.setMsg(parseObject.get("msg").asText());
                    }
                    if (parseObject.has("props")) {
                        sqsDataBuilder.setProps(parseObject.get("props").asText());
                    }
                    if (parseObject.has("version")) {
                        sqsDataBuilder.setVersion(parseObject.get("version").asText());
                    }
                    if (parseObject.has("context")) {
                        sqsDataBuilder.setContext(parseObject.get("context").asText());
                    }
                    if (parseObject.has("dataType")) {
                        DataType dataType = DataType.valueOf(parseObject.get("dataType").asText());
                        sqsDataBuilder.setDataType(dataType);
                        if (StringUtil.isNull((Object)sqsDataBuilder.getMsg()) && StringUtil.isNotNull((Object)sqsDataBuilder.getS3Key())) {
                            String objectForString;
                            S3Service s3 = S3ClientThreadlocal.createPerThreadS3Client();
                            if (dataType == DataType.inputStream) {
                                objectForString = s3.getObjectForStringStream(sqsDataBuilder.getBucketName(), sqsDataBuilder.getS3Key());
                                sqsDataBuilder.setMsg(objectForString);
                            } else {
                                objectForString = s3.getObjectForString(sqsDataBuilder.getBucketName(), sqsDataBuilder.getS3Key());
                                sqsDataBuilder.setMsg(objectForString);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    sqsDataBuilder.setQueueName(queueName);
                    sqsDataBuilder.setDataType(DataType.str);
                    sqsDataBuilder.setMsg(body);
                }
                ObjectNode properJson = JsonNodeFactory.instance.objectNode();
                if (StringUtil.isNotNull((Object)sqsDataBuilder.getProps())) {
                    properJson = (ObjectNode)JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)sqsDataBuilder.getProps());
                }
                if (MapUtils.isNotEmpty((Map)message.getMessageAttributes())) {
                    Map properties = message.getMessageAttributes();
                    for (String key : properties.keySet()) {
                        properJson.put(key, ((MessageAttributeValue)properties.get(key)).getStringValue());
                    }
                }
                sqsDataBuilder.setProperties(properJson.toString());
                messagecommon.setSqsData(sqsDataBuilder.build());
                retlist.add(messagecommon);
            }
        }
        return retlist;
    }

    public QueueAttributes getQueueAttributes(String queueName) {
        GetQueueAttributesRequest quest = new GetQueueAttributesRequest(queueName);
        quest.withAttributeNames(new String[]{"RedrivePolicy", "VisibilityTimeout", "ApproximateNumberOfMessages", "ApproximateNumberOfMessagesDelayed", "ApproximateNumberOfMessagesNotVisible", "MessageRetentionPeriod"});
        GetQueueAttributesResult queueAttributes = this.sqs.getQueueAttributes(quest);
        QueueAttributes.QueueAttributesBuilder builder = QueueAttributes.builder();
        String jsonstr = (String)queueAttributes.getAttributes().get("RedrivePolicy");
        if (StringUtil.isNotNull((Object)jsonstr)) {
            int intValue = JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)jsonstr).get("maxReceiveCount").intValue();
            builder.maxReceiveCount(intValue);
        }
        builder.VisibilityTimeout(new Integer((String)queueAttributes.getAttributes().get("VisibilityTimeout")));
        builder.approximateNumberOfMessages(new Integer((String)queueAttributes.getAttributes().get("ApproximateNumberOfMessages")));
        builder.approximateNumberOfMessagesDelayed(new Integer((String)queueAttributes.getAttributes().get("ApproximateNumberOfMessagesDelayed")));
        builder.approximateNumberOfMessagesNotVisible(new Integer((String)queueAttributes.getAttributes().get("ApproximateNumberOfMessagesNotVisible")));
        builder.MessageRetentionPeriod(new Integer((String)queueAttributes.getAttributes().get("MessageRetentionPeriod")));
        return builder.build();
    }

    public Result sendStrMsg(String queueName, String message, Map<String, String> properties, ObjectNode context, int delaySeconds) {
        try {
            Result sendRequestMsg = this.sendRequestMsg(queueName, message.getBytes("utf-8"), null, DataType.str, properties, context, delaySeconds);
            return sendRequestMsg;
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
            return Result.getError((String)("send error\uff1a" + e.getMessage()));
        }
    }

    public Result sendStrMsg(String queueName, String message, Map<String, String> properties) {
        return this.sendStrMsg(queueName, message, properties, null, 0);
    }

    public Result sendStrMsg(String queueName, String message, String bucketName, Map<String, String> properties) {
        try {
            if (StringUtil.isNull((Object)bucketName)) {
                return Result.getError((String)"Failed\uff1abucketName cannot be null");
            }
            Result result = this.sendRequestMsg(queueName, message.getBytes("utf-8"), bucketName, DataType.str, properties, null, 0);
            return result;
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
            return Result.getError((String)("send error\uff1a" + e.getMessage()));
        }
    }

    public Result sendBase64Msg(String queueName, byte[] message, Map<String, String> properties, ObjectNode context, int delaySeconds) {
        try {
            Result sendRequestMsg = this.sendRequestMsg(queueName, message, null, DataType.base64, properties, context, delaySeconds);
            return sendRequestMsg;
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
            return Result.getError((String)("send error\uff1a" + e.getMessage()));
        }
    }

    public Result sendBase64Msg(String queueName, byte[] message, Map<String, String> properties) {
        return this.sendBase64Msg(queueName, message, properties, null, 0);
    }

    public Result sendBase64Msg(String queueName, byte[] message, String bucketName, Map<String, String> properties) {
        try {
            if (StringUtil.isNull((Object)bucketName)) {
                return Result.getError((String)"Failed\uff1aBucketName cannot be null");
            }
            Result sendRequestMsg = this.sendRequestMsg(queueName, message, bucketName, DataType.base64, properties, null, 0);
            return sendRequestMsg;
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
            return Result.getError((String)("send error\uff1a" + e.getMessage()));
        }
    }

    public Result sendByteMsg(String queueName, byte[] msgBytes, Map<String, String> properties, ObjectNode context, int delaySeconds) {
        try {
            Result sendRequestMsg = this.sendRequestMsg(queueName, msgBytes, null, DataType.inputStream, properties, context, delaySeconds);
            return sendRequestMsg;
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
            return Result.getError((String)("send error\uff1a" + e.getMessage()));
        }
    }

    public Result sendByteMsg(String queueName, byte[] msgBytes, Map<String, String> properties) {
        return this.sendByteMsg(queueName, msgBytes, properties, null, 0);
    }

    public Result sendByteMsg(String queueName, byte[] msgBytes, String bucketName, Map<String, String> properties) {
        try {
            if (StringUtil.isNull((Object)bucketName)) {
                return Result.getError((String)"Failed\uff1aBucketName cannot be null");
            }
            Result sendRequestMsg = this.sendRequestMsg(queueName, msgBytes, bucketName, DataType.inputStream, properties, null, 0);
            return sendRequestMsg;
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
            return Result.getError((String)("send error\uff1a" + e.getMessage()));
        }
    }

    public List<String> queryQueuePrefix(String queueNamePrefix) {
        ListQueuesRequest request = new ListQueuesRequest();
        request.withQueueNamePrefix(queueNamePrefix);
        ListQueuesResult listQueues = this.sqs.listQueues(request);
        List queueUrls = listQueues.getQueueUrls();
        ArrayList<String> retlist = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)queueUrls)) {
            for (String queueUrl : queueUrls) {
                int lastIndexOf = queueUrl.lastIndexOf("/");
                String substring = queueUrl.substring(lastIndexOf + 1);
                retlist.add(substring);
            }
        }
        return retlist;
    }

    public Result sendSqsDataMsg(SqsData sqsData, String queueName) {
        String queueNameTrue = StringUtil.isNull((Object)queueName) ? sqsData.getQueueName() : queueName;
        Validate.notBlank((CharSequence)queueNameTrue, (String)"\u6570\u636e\u4e0d\u89c4\u5219\uff0cQueueName\u4e3a\u7a7a\u503c", (Object[])new Object[0]);
        if (StringUtil.isNotNull((Object)sqsData.getS3Key())) {
            SendMessageRequest messageRequest = new SendMessageRequest();
            ObjectNode propsJson = (ObjectNode)JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)sqsData.getProperties());
            ObjectNode bodyjson = JsonNodeFactory.instance.objectNode();
            if (propsJson != null && propsJson.size() < 10) {
                SdkInternalMap messageAttributes = new SdkInternalMap();
                Iterator iterator = propsJson.fieldNames();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    MessageAttributeValue attributeValue = new MessageAttributeValue();
                    if (!StringUtil.isNotNull((Object)propsJson.get(key))) continue;
                    attributeValue.setStringValue(String.valueOf(propsJson.get(key)));
                    attributeValue.setDataType("String");
                    messageAttributes.put((Object)key, (Object)attributeValue);
                }
                messageRequest.setMessageAttributes((Map)messageAttributes);
            } else if (propsJson != null) {
                bodyjson.put("props", sqsData.getProps());
            }
            if (StringUtil.isNotNull((Object)sqsData.getContext())) {
                bodyjson.put("context", sqsData.getContext());
            }
            bodyjson.put("dataType", sqsData.getDataType().name());
            bodyjson.put("bucketName", sqsData.getBucketName());
            bodyjson.put("s3key", sqsData.getS3Key());
            bodyjson.put("version", sqsData.getVersion());
            bodyjson.put("queueName", queueNameTrue);
            messageRequest.setQueueUrl(queueNameTrue);
            messageRequest.setMessageBody(bodyjson.toString());
            SendMessageResult sendMessage = this.sqs.sendMessage(messageRequest);
            return Result.getSuc((String)sendMessage.getMessageId());
        }
        ObjectNode contextObj = (ObjectNode)JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)sqsData.getContext());
        Map jsonToMap = JSONUtil.jsonToMap((ObjectNode)((ObjectNode)JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)sqsData.getProperties())));
        try {
            byte[] bytes = sqsData.getMsg().getBytes("utf-8");
            return this.sendRequestMsg(queueNameTrue, bytes, sqsData.getBucketName(), sqsData.getDataType(), jsonToMap, contextObj, 0);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("no suppered utf-8");
        }
    }

    public Result sendMessageTamsMsg(MessageCommon messagecommon, String queueName) {
        Validate.notBlank((CharSequence)queueName, (String)"queueName\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)queueName, (String)"\u6570\u636e\u4e0d\u89c4\u5219\uff0cQueueName\u4e3a\u7a7a\u503c", (Object[])new Object[0]);
        Validate.notNull((Object)messagecommon.getMessage(), (String)"\u9700\u8981\u539f\u59cb\u4fe1\u606f", (Object[])new Object[0]);
        SendMessageRequest messageRequest = new SendMessageRequest();
        messageRequest.setQueueUrl(queueName);
        Map messageAttributesOri = messagecommon.getMessage().getMessageAttributes();
        if (MapUtils.isNotEmpty((Map)messageAttributesOri)) {
            messageRequest.setMessageAttributes(messageAttributesOri);
        }
        String body = messagecommon.getMessage().getBody();
        messageRequest.setMessageBody(body);
        SendMessageResult sendMessage = this.sqs.sendMessage(messageRequest);
        return Result.getSuc((String)sendMessage.getMessageId());
    }

    public Result sendSqsDataMsg(SqsData sqsData) {
        return this.sendSqsDataMsg(sqsData, null);
    }

    private Result sendRequestMsg(String queueName, byte[] msgBytes, String bucketName, DataType dataType, Map<String, String> properties, ObjectNode context, int delaySeconds) {
        if (StringUtil.isNull((Object)queueName)) {
            return Result.getError((String)"Failed\uff1aQueueName cannot be null");
        }
        if (ArrayUtils.isEmpty((byte[])msgBytes)) {
            return Result.getError((String)"Failed\uff1aMsgBytes cannot be null");
        }
        if (dataType == null) {
            return Result.getError((String)"Failed\uff1adataType cannot be null");
        }
        SendMessageRequest messageRequest = new SendMessageRequest();
        ObjectNode jsonObject = JsonNodeFactory.instance.objectNode();
        String propsStr = "";
        int bodyMaxSize = Conf.getInt((String)"common.aws.sqs.sender.maxSize");
        SdkInternalMap messageAttributes = null;
        if (!MapUtils.isEmpty(properties)) {
            if (properties.keySet().size() > 10) {
                propsStr = JSONUtil.getJsonForMapStr(properties, (String[])new String[0]);
                try {
                    bodyMaxSize -= propsStr.getBytes("utf-8").length;
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Unsupported utf-8" + e);
                }
                Validate.isTrue((bodyMaxSize >= 0 ? 1 : 0) != 0, (String)("\u5c5e\u6027\u4e0d\u80fd\u8d85\u8fc7body\u6700\u5927\u503c\uff1a" + Conf.getInt((String)"common.aws.sqs.sender.maxSize")), (Object[])new Object[0]);
                jsonObject.set("props", JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)propsStr));
            } else {
                messageAttributes = new SdkInternalMap();
                for (String key : properties.keySet()) {
                    MessageAttributeValue attributeValue = new MessageAttributeValue();
                    if (!StringUtil.isNotNull((Object)properties.get(key))) continue;
                    attributeValue.setStringValue(String.valueOf(properties.get(key)));
                    attributeValue.setDataType("String");
                    messageAttributes.put((Object)key, (Object)attributeValue);
                }
                messageRequest.setMessageAttributes((Map)messageAttributes);
            }
        }
        if (delaySeconds > 0) {
            delaySeconds = delaySeconds < 900 ? delaySeconds : 900;
            messageRequest.setDelaySeconds(Integer.valueOf(delaySeconds));
        }
        if (context != null && context.size() > 0) {
            ObjectNode createPerThreadSqsContext = SqsContext.createPerThreadSqsContext();
            Map jsonToMap = JSONUtil.jsonToMap((ObjectNode)context);
            for (String key : jsonToMap.keySet()) {
                createPerThreadSqsContext.putPOJO(key, jsonToMap.get(key));
            }
            try {
                bodyMaxSize -= createPerThreadSqsContext.toString().getBytes("utf-8").length;
            }
            catch (UnsupportedEncodingException e) {
                log.error("Unsupported utf-8" + e);
            }
            Validate.isTrue((bodyMaxSize >= 0 ? 1 : 0) != 0, (String)("\u5c5e\u6027\u548ccontext\u4e4b\u548c\u4e0d\u80fd\u8d85\u8fc7body\u6700\u5927\u503c\uff1a" + Conf.getInt((String)"common.aws.sqs.sender.maxSize")), (Object[])new Object[0]);
            jsonObject.put("context", (JsonNode)createPerThreadSqsContext);
        }
        String msg = null;
        try {
            switch (dataType) {
                case base64: {
                    msg = PwdUtil.base64FromBin((byte[])msgBytes);
                    msgBytes = msg.getBytes("utf-8");
                    break;
                }
                case str: {
                    msg = new String(msgBytes, "utf-8");
                    break;
                }
                case inputStream: {
                    msg = new String(msgBytes, "ISO-8859-1");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e0d\u652f\u6301\u7684\u7f16\u7801", (Throwable)e);
        }
        if (msgBytes.length <= bodyMaxSize) {
            jsonObject.put("msg", msg);
        } else {
            this.convertS3(queueName, msgBytes, bucketName, dataType, jsonObject, msg);
        }
        messageRequest.setQueueUrl(queueName);
        jsonObject.put("queueName", queueName);
        jsonObject.putPOJO("dataType", (Object)dataType);
        jsonObject.put("version", VERSION);
        String msgAllStr = jsonObject.toString();
        try {
            if (msgAllStr.getBytes("utf-8").length + this.getMsgAttributesSize((Map<String, MessageAttributeValue>)messageAttributes) >= 262144) {
                jsonObject.remove("msg");
                this.convertS3(queueName, msgBytes, bucketName, dataType, jsonObject, msg);
                msgAllStr = jsonObject.toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unsupported utf-8" + e);
        }
        messageRequest.setMessageBody(msgAllStr);
        SendMessageResult sendMessage = this.sqs.sendMessage(messageRequest);
        return Result.getSuc((String)sendMessage.getMessageId());
    }

    private int getMsgAttributesSize(Map<String, MessageAttributeValue> msgAttributes) {
        int totalMsgAttributesSize = 0;
        if (msgAttributes == null) {
            return totalMsgAttributesSize;
        }
        for (Map.Entry<String, MessageAttributeValue> entry : msgAttributes.entrySet()) {
            ByteBuffer binaryVal;
            String stringVal;
            totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + SqsService.getStringSizeInBytes(entry.getKey()));
            MessageAttributeValue entryVal = entry.getValue();
            if (entryVal.getDataType() != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + SqsService.getStringSizeInBytes(entryVal.getDataType()));
            }
            if ((stringVal = entryVal.getStringValue()) != null) {
                totalMsgAttributesSize = (int)((long)totalMsgAttributesSize + SqsService.getStringSizeInBytes(entryVal.getStringValue()));
            }
            if ((binaryVal = entryVal.getBinaryValue()) == null) continue;
            totalMsgAttributesSize += binaryVal.array().length;
        }
        return totalMsgAttributesSize;
    }

    private static long getStringSizeInBytes(String str) {
        CountingOutputStream counterOutputStream = new CountingOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counterOutputStream, "UTF-8");
            writer.write(str);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            String errorMessage = "Failed to calculate the size of message payload.";
            log.error(errorMessage, (Throwable)e);
            throw new AmazonClientException(errorMessage, (Throwable)e);
        }
        return counterOutputStream.getTotalSize();
    }

    private void convertS3(String queueName, byte[] msgBytes, String bucketName, DataType dataType, ObjectNode jsonObject, String msg) {
        String relaPath = IOUtil.mergeFolderAndFilePath((String)queueName, (String[])new String[]{UUID.randomUUID().toString()});
        bucketName = AwsHelper.buildBucketName(bucketName);
        String s3key = AwsHelper.buildBucketKey(relaPath);
        jsonObject.put("bucketName", bucketName);
        jsonObject.put("s3key", s3key);
        S3Service s3 = S3ClientThreadlocal.createPerThreadS3Client();
        switch (dataType) {
            case base64: 
            case str: {
                s3.putObjectForStr(relaPath, msg);
                break;
            }
            case inputStream: {
                s3.putObjectForInputStream(relaPath, msgBytes);
                break;
            }
        }
    }

    public String createQueue(String queueName) {
        return this.createQueue(queueName, QueryType.queue, null, 0, 0, 0, 0);
    }

    private String createQueue(String sourceQueueName, QueryType queryType, String dlQueueName, int VisibilityTimeout, int ReceiveMessageWaitTimeSeconds, int MessageRetentionPeriod, int maxReceiveCount) {
        String queueUrl = "";
        try {
            if (sourceQueueName == null) {
                throw new IllegalArgumentException("SourceQueueName cannot be null.");
            }
            if (queryType == null) {
                throw new IllegalArgumentException("QueryType cannot be null.");
            }
            SetQueueAttributesRequest queueAttributes = new SetQueueAttributesRequest();
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (StringUtil.isNotNull((Object)dlQueueName)) {
                String deadLetterQueueUrl = this.creteQueue(dlQueueName, true);
                GetQueueAttributesResult deadLetterQueueAttributes = this.sqs.getQueueAttributes(new GetQueueAttributesRequest(deadLetterQueueUrl).withAttributeNames(new String[]{"QueueArn"}));
                String deadLetterQueueArn = (String)deadLetterQueueAttributes.getAttributes().get("QueueArn");
                ObjectNode redrivePolicy = JsonNodeFactory.instance.objectNode();
                redrivePolicy.put("maxReceiveCount", maxReceiveCount <= 0 ? Conf.get((String)"common.aws.sqs.dlq.maxReceiveCount") : String.valueOf(maxReceiveCount));
                redrivePolicy.put("deadLetterTargetArn", deadLetterQueueArn);
                attributes.put(QueueAttributeName.RedrivePolicy.toString(), redrivePolicy.toString());
            }
            attributes.put(QueueAttributeName.VisibilityTimeout.toString(), VisibilityTimeout <= 0 ? Conf.get((String)"common.aws.sqs.queue.visibilityTimeout") : String.valueOf(VisibilityTimeout));
            attributes.put(QueueAttributeName.ReceiveMessageWaitTimeSeconds.toString(), ReceiveMessageWaitTimeSeconds <= 0 ? Conf.get((String)"common.aws.sqs.queue.waitTimeSeconds") : String.valueOf(ReceiveMessageWaitTimeSeconds));
            attributes.put(QueueAttributeName.MessageRetentionPeriod.toString(), MessageRetentionPeriod <= 0 ? Conf.get((String)"common.aws.sqs.queue.MessageRetentionPeriod") : String.valueOf(MessageRetentionPeriod));
            queueAttributes.setAttributes(attributes);
            queueUrl = this.creteQueue(sourceQueueName, false);
            if (queryType == QueryType.fifo) {
                if (!sourceQueueName.endsWith(".fifo")) {
                    throw new IllegalArgumentException("The FIFO queue name must end with the .fifo suffix.");
                }
                attributes.put("FifoQueue", "true");
                attributes.put("ContentBasedDeduplication", "true");
            }
            queueAttributes.setQueueUrl(sourceQueueName);
            this.sqs.setQueueAttributes(queueAttributes);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa[" + sourceQueueName + "]\u961f\u5217\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u521b\u5efa[" + sourceQueueName + "]\u961f\u5217\u5931\u8d25\uff1a" + e.getMessage());
        }
        return queueUrl;
    }

    public String createQueue(String sourceQueueName, String dlQueueName, int VisibilityTimeout, int ReceiveMessageWaitTimeSeconds, int MessageRetentionPeriod, int maxReceiveCount) {
        return this.createQueue(sourceQueueName, QueryType.queue, dlQueueName, VisibilityTimeout, ReceiveMessageWaitTimeSeconds, MessageRetentionPeriod, maxReceiveCount);
    }

    public String createQueue(String sourceQueueName, String dlQueueName) {
        return this.createQueue(sourceQueueName, QueryType.queue, dlQueueName, 0, 0, 0, 0);
    }

    private String creteQueue(String queueName, boolean isDlq) {
        if (isDlq && StringUtil.isNull((Object)(queueName = StringUtil.hasNull((String[])new String[]{queueName, Conf.get((String)"common.aws.sqs.dlq.name")})))) {
            throw new IllegalArgumentException("DLQueueName cannot be null.");
        }
        return this.sqs.createQueue(queueName).getQueueUrl();
    }

    public DeleteMessageResult deleteMessage(SqsData msg) {
        DeleteMessageRequest batchRequest = new DeleteMessageRequest().withQueueUrl(msg.getQueueNameReceive()).withReceiptHandle(msg.getReceiptHandle());
        DeleteMessageResult deleteMessage = this.sqs.deleteMessage(batchRequest);
        return deleteMessage;
    }

    static {
        doWithTime = new HashMap<String, Long>();
    }
}

