/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.sqs.threadlocal;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class SqsContext implements ObjectCreator<ObjectNode> {

	public static final String  DEFAULTCOL = "context";// 如果没有传jsonstr过来则默认设置为此列的json

	private static final String PER_VAR_SQL_CLIENT = "perVarSqsContext";

	private SqsContext() {
	}

	@Override
	public ObjectNode createObject() {
		return JsonNodeFactory.instance.objectNode();
	}

	public static ObjectNode createPerThreadSqsContext() {
		ObjectCreator<ObjectNode> creator = PerthreadManager.getInstance().createValue(PER_VAR_SQL_CLIENT,
				new SqsContext());
		return creator.createObject();
	}

	public static void cleanContext() {
		PerthreadManager.getInstance().cleanValue(PER_VAR_SQL_CLIENT);
	}
}
