/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.sqs.threadlocal;

import net.wicp.tams.common.aws.common.AwsHelper;
import net.wicp.tams.common.aws.sqs.SqsService;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class SqsClientThreadlocal implements ObjectCreator<SqsService> {

	private static final String perVarSqsClient = "perVarSqsClient";

	private SqsClientThreadlocal() {
	}

	@Override
	public SqsService createObject() {
		SqsService createSqsService = AwsHelper.createSqsService();
		return createSqsService;
	}

	public static SqsService createPerThreadSqsClient() {
		ObjectCreator<SqsService> creator = PerthreadManager.getInstance().createValue(perVarSqsClient,
				new SqsClientThreadlocal());
		return creator.createObject();
	}

}
