/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.sqs.singleton;

import net.wicp.tams.common.aws.common.AwsHelper;
import net.wicp.tams.common.aws.sqs.SqsService;

public class SqsClientSingleton {
	private static volatile SqsClientSingleton inst;

	private final SqsService sqs;

	public SqsService getSqs() {
		return sqs;
	}

	private SqsClientSingleton() {
		this.sqs = AwsHelper.createSqsService();
	}

	public static SqsClientSingleton getInst() {
		if (inst == null) {
			synchronized (SqsClientSingleton.class) {
				if (inst == null) {
					inst = new SqsClientSingleton();
				}
			}
		}
		return inst;
	}
}
