/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.s3.threadlocal;

import net.wicp.tams.common.aws.common.AwsHelper;
import net.wicp.tams.common.aws.s3.S3Service;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class S3ClientThreadlocal implements ObjectCreator<S3Service> {

	private static final String perVarS3Client = "perVarS3Client";

	private S3ClientThreadlocal() {
	}

	@Override
	public S3Service createObject() {
		S3Service retobj = AwsHelper.createS3Service();
		return retobj;
	}

	public static S3Service createPerThreadS3Client() {
		ObjectCreator<S3Service> creator = PerthreadManager.getInstance().createValue(perVarS3Client,
				new S3ClientThreadlocal());
		return creator.createObject();
	}

}
