/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws.common;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;

public class TamsCredentialsProvider implements AWSCredentialsProvider {

	private AWSCredentials credentials;
	String awsAccessKey;
	String awsSecretKey;
	String sessionToken;
	private String accessKey;
	private String secretKey;

	/***
	 * 用于STS生成客户端的临时token
	 * 
	 * @param accessKey
	 * @param secretKey
	 */
	public TamsCredentialsProvider(String accessKey, String secretKey) {
		this.accessKey = accessKey;
		this.secretKey = secretKey;
		this.credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
	}

	public TamsCredentialsProvider() {
		if (StringUtil.isNotNull(Conf.get("common.aws.profile.accessKey"))
				&& StringUtil.isNotNull(Conf.get("common.aws.profile.secretKey"))) {
			this.accessKey = Conf.get("common.aws.profile.accessKey");
			this.secretKey = Conf.get("common.aws.profile.secretKey");
			this.credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
		} else {
			String awsAccessKey = Conf.get("common.aws.session.awsAccessKey");
			String awsSecretKey = Conf.get("common.aws.session.awsSecretKey");
			String sessionToken = Conf.get("common.aws.session.sessionToken");
			if (StringUtil.isNotNull(awsAccessKey) && StringUtil.isNotNull(awsSecretKey)
					&& StringUtil.isNotNull(sessionToken)) {
				this.credentials = new BasicSessionCredentials(awsAccessKey, awsSecretKey, sessionToken);
				this.awsAccessKey = awsAccessKey;
				this.awsSecretKey = awsSecretKey;
				this.sessionToken = sessionToken;
				System.out.println("awsAccessKey：------:" + this.awsAccessKey);
			}
		}
	}

	@Override
	public AWSCredentials getCredentials() {
		return this.credentials;
	}

	@Override
	public void refresh() {
		System.out.println("refresh");
		if (StringUtil.isNull(this.accessKey) || StringUtil.isNull(this.secretKey)) {
			System.out.print("进来了");
			String awsAccessKey = Conf.get("common.aws.session.awsAccessKey");
			String awsSecretKey = Conf.get("common.aws.session.awsSecretKey");
			String sessionToken = Conf.get("common.aws.session.sessionToken");
			if (StringUtil.isNotNull(awsAccessKey) && StringUtil.isNotNull(awsSecretKey)
					&& StringUtil.isNotNull(sessionToken) && (!awsAccessKey.equals(awsAccessKey)
							|| !awsSecretKey.equals(awsSecretKey) || !sessionToken.equals(sessionToken))) {
				this.credentials = new BasicSessionCredentials(awsAccessKey, awsSecretKey, sessionToken);
				this.awsAccessKey = awsAccessKey;
				this.awsSecretKey = awsSecretKey;
				this.sessionToken = sessionToken;
			}
		}
	}

}
