/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.aws;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.FileUtils;

import com.amazonaws.services.s3.model.S3ObjectInputStream;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.aws.s3.singleton.S3ClientSingleton;
import net.wicp.tams.common.callback.IRemote;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

@Slf4j
public class TamsRemoteImpl implements IRemote {
	// eg:s3://dev-xforceplus-mq/duckula/plugins/duckula-plugin-es5.tar
	@Override
	public InputStream findStream(String path) {
		String pathtrue = path.replace("s3:", "").replace("//", "/");
		pathtrue = pathtrue.charAt(0) == '/' ? pathtrue.substring(1) : pathtrue;
		int firstIndexOf = pathtrue.indexOf("/");
		S3ObjectInputStream objectForStream = S3ClientSingleton.getInst().getS3()
				.getObjectForStream(pathtrue.substring(0, firstIndexOf), pathtrue.substring(firstIndexOf + 1));
		return objectForStream;
	}

	@Override
	public void findStream(String path, String localPath) {
		try {
			FileUtils.copyInputStreamToFile(findStream(path), new File(localPath));
		} catch (IOException e) {
			log.error("取S3文件错误", e);
			throw new ProjectExceptionRuntime(ExceptAll.project_undefined, "取S3文件错误");
		}
	}

}
