/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.aws.sts;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.aws.common.TamsCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StsService {
    private static final Logger log = LoggerFactory.getLogger(StsService.class);

    public Credentials createSessionToken(String accessKey, String secretKey) {
        try {
            AWSSecurityTokenService awsSts = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClient.builder().withRegion(Conf.get((String)"common.aws.region"))).withCredentials((AWSCredentialsProvider)new TamsCredentialsProvider(accessKey, secretKey))).build();
            GetSessionTokenRequest tokenRequest = new GetSessionTokenRequest();
            tokenRequest.setDurationSeconds(Conf.getInt((String)"common.aws.sts.token.durationSeconds"));
            return awsSts.getSessionToken(tokenRequest).getCredentials();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6sts\u4e34\u65f6\u51ed\u8bc1\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6sts\u4e34\u65f6\u51ed\u8bc1\u5931\u8d25");
        }
    }
}

