/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.aws.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.stream.Collectors;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.PwdUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.aws.DataType;
import net.wicp.tams.common.aws.common.AwsHelper;
import net.wicp.tams.common.aws.common.TamsCredentialsProvider;
import net.wicp.tams.common.aws.s3.threadlocal.S3ClientThreadlocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Service {
    private static final Logger log = LoggerFactory.getLogger(S3Service.class);
    private final AmazonS3 s3;

    private S3Service(AmazonS3 s3) {
        this.s3 = s3;
    }

    private S3Service() {
        AmazonS3 s3;
        this.s3 = s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(Conf.get((String)"common.aws.region"))).withCredentials((AWSCredentialsProvider)new TamsCredentialsProvider())).build();
    }

    public static S3Service getInstThread() {
        S3Service createPerThreadEsClient = S3ClientThreadlocal.createPerThreadS3Client();
        return createPerThreadEsClient;
    }

    public <T> PutObjectResult putObjectForStr(String fileRelaPath, String t) {
        String buildBucketName = AwsHelper.buildBucketName(Conf.get((String)"common.aws.sqs.s3.bucketName"));
        String buildBucketKey = AwsHelper.buildBucketKey(fileRelaPath);
        return this.putObject(buildBucketName, null, buildBucketKey, DataType.str, t.getBytes());
    }

    public <T> PutObjectResult putObjectForBase64(String fileRelaPath, byte[] t) {
        String buildBucketName = AwsHelper.buildBucketName(Conf.get((String)"common.aws.sqs.s3.bucketName"));
        String buildBucketKey = AwsHelper.buildBucketKey(fileRelaPath);
        return this.putObject(buildBucketName, null, buildBucketKey, DataType.base64, t);
    }

    public <T> PutObjectResult putObjectForInputStream(String fileRelaPath, InputStream inputStream) {
        return this.putObjectForInputStream(fileRelaPath, AwsHelper.getBytes(inputStream));
    }

    public <T> PutObjectResult putObjectForInputStream(String fileRelaPath, byte[] byteArr) {
        String buildBucketName = AwsHelper.buildBucketName(Conf.get((String)"common.aws.sqs.s3.bucketName"));
        String buildBucketKey = AwsHelper.buildBucketKey(fileRelaPath);
        return this.putObject(buildBucketName, null, buildBucketKey, DataType.inputStream, byteArr);
    }

    public <T> PutObjectResult putObjectForInputStream(String fileRelaPath, File t) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(t);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return this.putObjectForInputStream(fileRelaPath, fis);
    }

    public <T> PutObjectResult putObject(String fileRelaPath, byte[] byteArr, DataType dataType) {
        String buildBucketName = AwsHelper.buildBucketName(Conf.get((String)"common.aws.sqs.s3.bucketName"));
        String buildBucketKey = AwsHelper.buildBucketKey(fileRelaPath);
        return this.putObject(buildBucketName, null, buildBucketKey, dataType, byteArr);
    }

    public <T> PutObjectResult putObject(String bucketName, String rootPath, String fileRelaPath, DataType dataType, byte[] t) {
        bucketName = StringUtil.hasNull((String[])new String[]{bucketName, Conf.get((String)"common.aws.sqs.s3.bucketName")});
        String pathTrue = IOUtil.mergeFolderAndFilePath((String)rootPath, (String[])new String[]{fileRelaPath});
        PutObjectResult putObject = null;
        if (pathTrue.startsWith("/")) {
            pathTrue = pathTrue.substring(1);
        }
        switch (dataType) {
            case base64: {
                String base64FromBin = PwdUtil.base64FromBin((byte[])t);
                putObject = this.s3.putObject(bucketName, pathTrue, base64FromBin);
                break;
            }
            case str: {
                try {
                    putObject = this.s3.putObject(bucketName, pathTrue, new String(t, "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("UnsupportedEncodingException", (Throwable)e);
                }
                break;
            }
            case inputStream: {
                putObject = this.s3.putObject(bucketName, pathTrue, (InputStream)new ByteArrayInputStream(t), new ObjectMetadata());
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
            }
        }
        return putObject;
    }

    public String getObjectForString(String bucketName, String keyName) {
        S3ObjectInputStream inputStream = null;
        try {
            String slurp;
            S3Object o = this.s3.getObject(bucketName, keyName);
            inputStream = o.getObjectContent();
            String string = slurp = new BufferedReader(new InputStreamReader((InputStream)inputStream)).lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
        catch (Exception e) {
            log.error("\u53d6\u5f97s3\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u53d6\u5f97s3\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getObjectForStringStream(String bucketName, String keyName) {
        S3ObjectInputStream inputStream = null;
        try {
            String slurp;
            S3Object o = this.s3.getObject(bucketName, keyName);
            inputStream = o.getObjectContent();
            String string = slurp = S3Service.slurp((InputStream)inputStream, "ISO-8859-1");
            return string;
        }
        catch (Exception e) {
            log.error("\u53d6\u5f97s3\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u53d6\u5f97s3\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String slurp(InputStream in, String oriEncoding) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n, oriEncoding));
        }
        return out.toString();
    }

    public String getObjectForString(String relaKeyName) {
        String buildBucketName = AwsHelper.buildBucketName(Conf.get((String)"common.aws.sqs.s3.bucketName"));
        String buildBucketKey = AwsHelper.buildBucketKey(relaKeyName);
        return this.getObjectForString(buildBucketName, buildBucketKey);
    }

    public byte[] getObjectForBytes(String bucketName, String keyName) {
        S3ObjectInputStream stream = this.getObjectForStream(bucketName, keyName);
        byte[] bytes = AwsHelper.getBytes((InputStream)stream);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bytes;
    }

    public S3ObjectInputStream getObjectForStream(String bucketName, String keyName) {
        S3ObjectInputStream s3is = null;
        try {
            S3Object o = this.s3.getObject(bucketName, keyName);
            s3is = o.getObjectContent();
            return s3is;
        }
        catch (Exception e) {
            log.error("\u53d6\u5f97s3\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u53d6\u5f97s3\u6587\u4ef6\u5931\u8d25");
        }
    }

    public byte[] getObjectForBytes(String relaKeyName) {
        String buildBucketName = AwsHelper.buildBucketName(Conf.get((String)"common.aws.sqs.s3.bucketName"));
        String buildBucketKey = AwsHelper.buildBucketKey(relaKeyName);
        return this.getObjectForBytes(buildBucketName, buildBucketKey);
    }

    public void getObjectForFile(String bucketName, String keyName, String savePath) {
        S3ObjectInputStream s3is = null;
        FileOutputStream fos = null;
        try {
            S3Object o = this.s3.getObject(bucketName, keyName);
            s3is = o.getObjectContent();
            fos = new FileOutputStream(new File(StringUtil.isNotNull((Object)savePath) ? savePath : keyName));
            IOUtil.copyInToOut((InputStream)s3is, (OutputStream)fos);
        }
        catch (Exception e) {
            log.error("\u53d6\u5f97s3\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u53d6\u5f97s3\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            try {
                if (s3is != null) {
                    s3is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void getObjectForFile(String relaKeyName, String savePath) {
        String buildBucketName = AwsHelper.buildBucketName(Conf.get((String)"common.aws.sqs.s3.bucketName"));
        String buildBucketKey = AwsHelper.buildBucketKey(relaKeyName);
        this.getObjectForFile(buildBucketName, buildBucketKey, savePath);
    }
}

